/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.groupchat;

import nu.fw.jeti.backend.roster.NormalJIDStatus;
import nu.fw.jeti.backend.roster.Roster;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.jabber.elements.Presence;
import nu.fw.jeti.plugins.groupchat.elements.XMUCUser;
import nu.fw.jeti.util.Preferences;

class Actor
extends NormalJIDStatus {
    private int role;
    private int affiliation;
    private JID fullJID;

    Actor(JID jID) {
        super(jID, jID.getResource());
    }

    public void update(Presence presence, XMUCUser xMUCUser) {
        this.updatePresence(presence);
        if (xMUCUser != null) {
            JIDStatus jIDStatus;
            this.role = xMUCUser.getRole();
            this.affiliation = xMUCUser.getAffiliation();
            this.fullJID = xMUCUser.getJID();
            if (this.fullJID != null && (jIDStatus = Roster.getJIDStatus((JID)this.fullJID)) != null && jIDStatus.getNick() != null && Preferences.getBoolean((String)"groupchat", (String)"showNick", (boolean)true)) {
                String string = " (" + jIDStatus.getNick() + ")";
                if (!this.getNick().endsWith(string)) {
                    this.setNick(this.getNick() + string);
                }
            }
        }
    }

    public int getAffiliation() {
        return this.affiliation;
    }

    public int getRole() {
        return this.role;
    }

    public JID getFullJID() {
        return this.fullJID;
    }

    public JID getCompleteJID() {
        if (this.fullJID != null) {
            return this.fullJID;
        }
        return this.getJID();
    }

    public boolean equals(Object object) {
        if (object instanceof Actor) {
            Actor actor = (Actor)((Object)object);
            return actor.getJID().getResource().equals(this.getJID().getResource());
        }
        return false;
    }

    public int hashCode() {
        return this.getJID().getResource().hashCode();
    }
}

