/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.filetransfer;

import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.handlers.ExtensionHandler;
import nu.fw.jeti.plugins.filetransfer.XSiFileTransfer;
import nu.fw.jeti.util.Log;
import org.xml.sax.Attributes;

public class XSiFileTransferHandler
extends ExtensionHandler {
    private String name;
    private String hash;
    private String date;
    private String description;
    private long size;
    private int length;
    private long offset;

    public void startHandling(Attributes attr) {
        this.name = attr.getValue("name");
        this.hash = attr.getValue("hash");
        this.date = attr.getValue("date");
        try {
            this.size = Long.parseLong(attr.getValue("size"));
        }
        catch (NumberFormatException e) {
            this.size = 0L;
            Log.xmlReceivedError((String)"Si profile, size is not a number");
        }
        this.length = 0;
        this.offset = 0L;
    }

    public void startElement(String name, Attributes attr) {
        if (name.equals("range")) {
            try {
                this.length = Integer.parseInt(attr.getValue("length"));
                this.offset = Long.parseLong(attr.getValue("offset"));
            }
            catch (NumberFormatException e) {
                this.size = 0L;
                Log.xmlReceivedError((String)"Si profile, range is not a number");
            }
        }
    }

    public void endElement(String name) {
        if (name.equals("desc")) {
            this.description = this.getText();
        }
        this.clearCurrentChars();
    }

    public Extension build() {
        return new XSiFileTransfer(this.name, this.hash, this.date, this.size, this.description, this.length, this.offset);
    }
}

