/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.filetransfer;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.plugins.PreferencesPanel;
import nu.fw.jeti.plugins.filetransfer.Plugin;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;

public class PrefPanel
extends PreferencesPanel {
    private JComboBox cmbIP;
    private JTextField txtPort = new JTextField();
    private JCheckBox chkUseLocal;
    private JCheckBox chkCloseOnComplete;

    public PrefPanel(Backend backend) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 21;
        c.fill = 2;
        c.insets = new Insets(3, 5, 0, 3);
        String choosen = Preferences.getString((String)"filetransfer", (String)"ip", null);
        String ip = Plugin.getIP();
        String[] ips = choosen != null && !choosen.equals("automatic") ? (ip != null ? new String[]{choosen, ip, String.valueOf(I18N.gettext((String)"filetransfer.automatic")) + " (" + ip + ")"} : new String[]{choosen}) : (ip != null ? new String[]{String.valueOf(I18N.gettext((String)"filetransfer.automatic")) + " (" + ip + ")", ip} : new String[]{});
        this.cmbIP = new JComboBox<String>(ips);
        this.cmbIP.setEditable(true);
        this.txtPort.setText(Preferences.getString((String)"filetransfer", (String)"port", (String)"7777"));
        this.chkUseLocal = new JCheckBox(I18N.gettext((String)"filetransfer.behind_firewall_or_NAT"));
        this.chkUseLocal.setSelected(!Preferences.getBoolean((String)"filetransfer", (String)"useLocalIP", (boolean)false));
        this.add(this.chkUseLocal, c);
        c.gridwidth = 1;
        c.anchor = 21;
        this.add(new JLabel(I18N.gettext((String)"filetransfer.ip")), c);
        c.gridwidth = 0;
        this.add(this.cmbIP, c);
        c.gridwidth = 1;
        this.add(new JLabel(I18N.gettext((String)"filetransfer.port")), c);
        c.gridwidth = 0;
        this.add(this.txtPort, c);
        c.gridwidth = 0;
        this.chkCloseOnComplete = new JCheckBox(I18N.gettext((String)"filetransfer.close_download_windows_when_download_ready"));
        this.chkCloseOnComplete.setSelected(Preferences.getBoolean((String)"filetransfer", (String)"closeOnComplete", (boolean)false));
        this.add(this.chkCloseOnComplete, c);
        c.gridwidth = 2;
        c.weighty = 1.0;
        c.weightx = 1.0;
        this.add(Box.createVerticalGlue(), c);
    }

    public void savePreferences() {
        String ip;
        Preferences.putBoolean((String)"filetransfer", (String)"useLocalIP", (!this.chkUseLocal.isSelected() ? 1 : 0) != 0);
        Preferences.putBoolean((String)"filetransfer", (String)"closeOnComplete", (boolean)this.chkCloseOnComplete.isSelected());
        if ((this.cmbIP.getSelectedIndex() != -1 || this.cmbIP.getSelectedItem() != null && !this.cmbIP.getSelectedItem().equals("")) && (ip = this.cmbIP.getSelectedItem().toString()) != null) {
            if (ip.startsWith(I18N.gettext((String)"filetransfer.automatic"))) {
                ip = "automatic";
            }
            Preferences.putString((String)"filetransfer", (String)"ip", (String)ip);
        }
        if (!this.txtPort.getText().equals("")) {
            try {
                int scrollTime = Integer.parseInt(this.txtPort.getText());
                Preferences.putInteger((String)"titlescroller", (String)"scrolltime", (int)scrollTime);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

