/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import java.nio.BufferUnderflowException;

public class Bits {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    private byte[] bytes;
    private int bytePtr;
    private int bitPtr;
    private int bytesToUnpack;

    public void init() {
        this.bytes = new byte[1024];
        this.bytePtr = 0;
        this.bitPtr = 0;
        this.bytesToUnpack = 0;
    }

    public void advance(int n) {
        this.bytePtr += n >> 3;
        this.bitPtr += n & 7;
        if (this.bitPtr > 7) {
            this.bitPtr -= 8;
            ++this.bytePtr;
        }
        this.checkUnderflow();
    }

    protected void setBuffer(byte[] byArray) {
        this.bytes = byArray;
    }

    public int peek() {
        return (this.bytes[this.bytePtr] & 0xFF) >> 7 - this.bitPtr & 1;
    }

    public void read_from(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            this.bytes[n3] = byArray[n + n3];
            ++n3;
        }
        this.bytePtr = 0;
        this.bitPtr = 0;
        this.bytesToUnpack = n2;
    }

    public int unpack(int n) {
        int n2 = 0;
        while (n != 0) {
            n2 <<= 1;
            n2 |= (this.bytes[this.bytePtr] & 0xFF) >> 7 - this.bitPtr & 1;
            ++this.bitPtr;
            if (this.bitPtr == 8) {
                this.bitPtr = 0;
                ++this.bytePtr;
            }
            --n;
        }
        this.checkUnderflow();
        return n2;
    }

    public void pack(int n, int n2) {
        int n3;
        int n4 = n;
        while (this.bytePtr + (n2 + this.bitPtr >> 3) >= this.bytes.length) {
            n3 = this.bytes.length * 2;
            byte[] byArray = new byte[n3];
            System.arraycopy(this.bytes, 0, byArray, 0, this.bytes.length);
            this.bytes = byArray;
        }
        while (n2 > 0) {
            n3 = n4 >> n2 - 1 & 1;
            int n5 = this.bytePtr++;
            this.bytes[n5] = (byte)(this.bytes[n5] | n3 << 7 - this.bitPtr);
            ++this.bitPtr;
            if (this.bitPtr == 8) {
                this.bitPtr = 0;
            }
            --n2;
        }
    }

    public byte[] getBuffer() {
        return this.bytes;
    }

    public int getBufferSize() {
        return this.bytePtr + (this.bitPtr > 0 ? 1 : 0);
    }

    private void checkUnderflow() {
        if (this.bytePtr < this.bytesToUnpack) {
            return;
        }
        if (this.bytePtr > this.bytesToUnpack || this.bitPtr > 0) {
            throw new BufferUnderflowException();
        }
    }

    public boolean hasFrameToUnpack() {
        return this.bytePtr < this.bytesToUnpack - 1 || this.bytePtr < this.bytesToUnpack && this.bitPtr < 4;
    }

    public void insertTerminator() {
        if (this.bitPtr > 0) {
            if (++this.bitPtr < 8) {
                int n = this.bytePtr;
                this.bytes[n] = (byte)(this.bytes[n] | 63 >> this.bitPtr - 2);
            }
            ++this.bytePtr;
            this.bitPtr = 0;
        }
    }
}

