/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.drawing.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import nu.fw.jeti.plugins.drawing.shapes.PicturesContent;
import nu.fw.jeti.plugins.drawing.ui.UserRepresentation;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneHistoryPicturePanel
extends JPanel {
    private PicturesContent picture;
    private OneHistoryPicturePanelContent content;
    private TitledBorder titledBorder;
    private Set<UserRepresentation> displayedAuthors;
    private Dimension size = new Dimension(140, 128);
    private static final int PICTURE_WIDTH = 128;
    private static final int PICTURE_HEIGHT = 96;
    private static final long serialVersionUID = -711206238878186129L;

    public OneHistoryPicturePanel(PicturesContent picturesContent, String string, Set<UserRepresentation> set) {
        this.picture = picturesContent;
        this.displayedAuthors = set;
        this.content = new OneHistoryPicturePanelContent();
        this.content.setVisible(true);
        this.add(this.content);
        this.setFrame(this, string);
        this.setVisible(true);
    }

    public PicturesContent getPicture() {
        return this.picture;
    }

    public void changeFrameTitle(String string) {
        this.titledBorder.setTitle(string);
    }

    private void setFrame(JComponent jComponent, String string) {
        this.titledBorder = BorderFactory.createTitledBorder(string);
        jComponent.setBorder(this.titledBorder);
    }

    public void setPicture(PicturesContent picturesContent) {
        this.picture = picturesContent;
    }

    public void setDisplayAuthors(Set<UserRepresentation> set) {
        this.displayedAuthors = set;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.size;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    private class OneHistoryPicturePanelContent
    extends JPanel {
        private static final long serialVersionUID = 5347205750717912204L;

        private OneHistoryPicturePanelContent() {
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (OneHistoryPicturePanel.this.displayedAuthors != null) {
                OneHistoryPicturePanel.this.picture.drawPicture(graphics, 128, 96, OneHistoryPicturePanel.this.displayedAuthors);
            } else {
                OneHistoryPicturePanel.this.picture.drawPicture(graphics, 128, 96);
            }
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            return new Dimension(128, 96);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }
}

