/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.drawing.ui;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.CSS;
import nu.fw.jeti.plugins.drawing.ui.Board;
import nu.fw.jeti.plugins.drawing.ui.PictureChatFrame;
import nu.fw.jeti.plugins.xhtml.fontchooser.FontDialog;
import nu.fw.jeti.util.I18N;

class FontSelectAction
extends AbstractAction {
    private static final long serialVersionUID = -8637703530410277069L;
    private PictureChatFrame frame;
    private Board board;

    public FontSelectAction(String string, ImageIcon imageIcon, String string2, Integer n, PictureChatFrame pictureChatFrame, Board board) {
        super(string, imageIcon);
        this.frame = pictureChatFrame;
        this.board = board;
        this.putValue("ShortDescription", string2);
        this.putValue("MnemonicKey", n);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Color color;
        String string;
        int n;
        AttributeSet attributeSet = new SimpleAttributeSet();
        FontDialog fontDialog = new FontDialog((Frame)this.frame, I18N.getText((String)"drawing", (String)"Choose_font"), attributeSet);
        fontDialog.setModal(true);
        fontDialog.setVisible(true);
        attributeSet = fontDialog.getAttributes();
        String string2 = StyleConstants.getFontFamily(attributeSet);
        if (string2 != null) {
            this.board.setFontFamily(string2);
        }
        if ((n = StyleConstants.getFontSize(attributeSet)) > 0) {
            this.board.setFontSize(n);
        }
        int n2 = 0;
        if (attributeSet.isDefined(CSS.Attribute.FONT_STYLE) && (string = attributeSet.getAttribute(CSS.Attribute.FONT_STYLE).toString()).equalsIgnoreCase(StyleConstants.Italic.toString())) {
            n2 = 2;
        }
        if (attributeSet.isDefined(CSS.Attribute.FONT_WEIGHT) && (string = attributeSet.getAttribute(CSS.Attribute.FONT_WEIGHT).toString()).equalsIgnoreCase(StyleConstants.Bold.toString())) {
            n2 = n2 == 2 ? 3 : 1;
        }
        this.board.setFontStyle(n2);
        Color color2 = StyleConstants.getForeground(attributeSet);
        if (color2 != null) {
            this.board.setFontForegroundColor(color2);
        }
        if ((color = StyleConstants.getBackground(attributeSet)) != null) {
            this.board.setFontBackgroundColor(color);
        }
    }
}

