/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.drawing.shapes;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sourceforge.retroweaver.runtime.java.lang.Long_;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.plugins.drawing.Plugin;
import nu.fw.jeti.plugins.drawing.geometry.PointsOperations;
import nu.fw.jeti.plugins.drawing.geometry.Vector;
import nu.fw.jeti.plugins.drawing.shapes.Shape;
import nu.fw.jeti.plugins.drawing.shapes.ShapePriorityStack;
import nu.fw.jeti.plugins.drawing.shapes.TextShape;
import nu.fw.jeti.plugins.drawing.ui.UserRepresentation;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PicturesContent {
    private ShapePriorityStack contents = new ShapePriorityStack();
    private List<Shape> currentlySelected;
    private Color backgroundColor;
    private List<ActionListener> listeners = Collections.synchronizedList(new ArrayList());
    public static final int AUTHOR_DISPLAY = 1;
    private static final double MARGIN_LENGTH = 0.03;
    public static final Color DEFAULT_BACKGROUND_COLOR = Color.WHITE;

    public PicturesContent() {
        this.currentlySelected = Collections.synchronizedList(new ArrayList());
        this.backgroundColor = DEFAULT_BACKGROUND_COLOR;
    }

    public synchronized void addShape(Shape shape) {
        this.contents.add(shape);
        this.pictureChanged();
    }

    public synchronized void addShapeList(List<Shape> list, boolean bl) {
        for (Shape object2 : list) {
            this.contents.add(object2);
        }
        if (bl) {
            this.unselect();
            this.currentlySelected = list;
        }
        Shape shape = list.get(0);
        String string = new StringBuffer().append(shape.getAuthor()).append(" ").append(shape.getDisplayPoint().x).append(" ").append(shape.getDisplayPoint().y).toString();
        this.pictureChanged(new ActionEvent(this, 1, string));
    }

    private synchronized void pictureChanged(ActionEvent actionEvent) {
        for (ActionListener actionListener : this.listeners) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    public synchronized void drawPictureWithSelection(Graphics graphics, int n, int n2) {
        this.drawPicture(graphics, n, n2);
        for (Shape shape : this.currentlySelected) {
            shape.drawAsSelected(graphics, n, n2);
        }
    }

    public void drawPicture(Graphics graphics, int n, int n2) {
        this.setBackground(graphics, n, n2);
        for (int i = 0; i < this.contents.size(); ++i) {
            Shape shape = this.contents.get(i);
            shape.draw(graphics, n, n2);
        }
    }

    public void drawPicture(Graphics graphics, int n, int n2, Set<UserRepresentation> set) {
        this.setBackground(graphics, n, n2);
        for (int i = 0; i < this.contents.size(); ++i) {
            Shape shape = this.contents.get(i);
            JID jID = shape.getAuthor();
            for (UserRepresentation userRepresentation : set) {
                if (!jID.equals(userRepresentation.getJID())) continue;
                shape.draw(graphics, n, n2);
            }
        }
    }

    private void setBackground(Graphics graphics, int n, int n2) {
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(0, 0, n, n2);
    }

    public synchronized void deleteShape(Shape shape) {
        this.contents.remove(shape);
        this.pictureChanged();
    }

    public synchronized void deleteShapeList(List<Shape> list) {
        for (Shape shape : list) {
            this.contents.remove(shape);
        }
        this.pictureChanged();
    }

    public synchronized void pictureChanged() {
        this.pictureChanged(null);
    }

    public synchronized void addListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    public synchronized void selectItems(Point2D.Double double_, Point2D.Double double_2) {
        this.unselect();
        Point2D.Double double_3 = PointsOperations.upperLeftPoint(double_, double_2);
        Point2D.Double double_4 = PointsOperations.bottomRightPoint(double_, double_2);
        for (int i = 0; i < this.contents.size(); ++i) {
            Shape shape = this.contents.get(i);
            if (!shape.isInsideTheRect(double_3, double_4)) continue;
            this.currentlySelected.add(shape);
        }
        this.pictureChanged();
    }

    public List<Shape> getCurrentlySelected() {
        return this.currentlySelected;
    }

    public synchronized void selectItem(Point2D.Double double_, int n, int n2) {
        this.unselect();
        for (int i = this.contents.size() - 1; i >= 0; --i) {
            Shape shape = this.contents.get(i);
            if (!shape.isPointInShapesNeighbourhood(double_, n, n2)) continue;
            this.currentlySelected.add(shape);
            this.pictureChanged();
            return;
        }
    }

    public void unselect() {
        this.currentlySelected.clear();
        this.pictureChanged();
    }

    public boolean checkIfClickedInSelection(Point2D.Double double_, int n, int n2) {
        if (this.currentlySelected.isEmpty()) {
            return false;
        }
        for (Shape shape : this.currentlySelected) {
            if (!shape.isPointInShapesNeighbourhood(double_, n, n2)) continue;
            return true;
        }
        return false;
    }

    public Shape getShapeFromNeighbourhood(Point2D.Double double_, int n, int n2) {
        for (int i = 0; i < this.contents.size(); ++i) {
            Shape shape = this.contents.get(i);
            if (!shape.isPointInShapesNeighbourhood(double_, n, n2)) continue;
            return shape;
        }
        return null;
    }

    public List<Long> getSelectedShapesIdList() {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (Shape shape : this.currentlySelected) {
            arrayList.add(Long_.valueOf((long)shape.getShapeId()));
        }
        return arrayList;
    }

    public void moveShapes(Vector vector) {
        for (Shape shape : this.currentlySelected) {
            shape.changeCoordinates(vector);
        }
        this.pictureChanged();
    }

    public void selectAll() {
        this.unselect();
        for (int i = 0; i < this.contents.size(); ++i) {
            this.currentlySelected.add(this.contents.get(i));
        }
        this.pictureChanged();
    }

    public TextShape getClickedTextShape(Point2D.Double double_, int n, int n2) {
        for (int i = this.contents.size() - 1; i >= 0; --i) {
            TextShape textShape;
            if (!(this.contents.get(i) instanceof TextShape) || !(textShape = (TextShape)this.contents.get(i)).isPointInShapesInterior(double_, n, n2)) continue;
            return textShape;
        }
        return null;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        this.pictureChanged();
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Point2D.Double getTheMostUpperLeftPoint() {
        Point2D.Double double_ = null;
        for (int i = 0; i < this.contents.size(); ++i) {
            Point2D.Double double_2 = this.contents.get(i).getTheMostUpperLeftPoint();
            if (double_ == null) {
                double_ = new Point2D.Double(double_2.x, double_2.y);
                continue;
            }
            if (double_2.x < double_.x) {
                double_.x = double_2.x;
            }
            if (!(double_2.y < double_.y)) continue;
            double_.y = double_2.y;
        }
        return double_;
    }

    public Point2D.Double getTheMostUpperLeftPointAmongGaveList(List<Shape> list) {
        Point2D.Double double_ = null;
        for (Shape shape : list) {
            Point2D.Double double_2 = shape.getTheMostUpperLeftPoint();
            if (double_ == null) {
                double_ = new Point2D.Double(double_2.x, double_2.y);
                continue;
            }
            if (double_2.x < double_.x) {
                double_.x = double_2.x;
            }
            if (!(double_2.y < double_.y)) continue;
            double_.y = double_2.y;
        }
        double_.x -= 0.03;
        double_.y -= 0.03;
        return double_;
    }

    public Point2D.Double getTheMostBottomRighttPointAmongGaveList(List<Shape> list) {
        Point2D.Double double_ = null;
        for (Shape shape : list) {
            Point2D.Double double_2 = shape.getTheMostBottomRightPoint();
            if (double_ == null) {
                double_ = new Point2D.Double(double_2.x, double_2.y);
                continue;
            }
            if (double_2.x > double_.x) {
                double_.x = double_2.x;
            }
            if (!(double_2.y > double_.y)) continue;
            double_.y = double_2.y;
        }
        return double_;
    }

    public Point2D.Double getTheMostBottomRightPoint() {
        Point2D.Double double_ = null;
        for (int i = 0; i < this.contents.size(); ++i) {
            Point2D.Double double_2 = this.contents.get(i).getTheMostBottomRightPoint();
            if (double_ == null) {
                double_ = new Point2D.Double(double_2.x, double_2.y);
                continue;
            }
            if (double_2.x > double_.x) {
                double_.x = double_2.x;
            }
            if (!(double_2.y > double_.y)) continue;
            double_.y = double_2.y;
        }
        double_.x += 0.03;
        double_.y += 0.03;
        return double_;
    }

    public PicturesContent copy() {
        PicturesContent picturesContent = new PicturesContent();
        picturesContent.backgroundColor = this.backgroundColor;
        ShapePriorityStack shapePriorityStack = new ShapePriorityStack();
        for (int i = 0; i < this.contents.size(); ++i) {
            Shape shape = this.contents.get(i);
            Shape shape2 = Plugin.createShape(shape.getName(), shape.getShapeId(), shape.getAuthor(), shape.getCoordinates(), shape.getColor(), shape.getDisplayHeight(), shape.isFilled());
            shapePriorityStack.add(shape2);
        }
        picturesContent.contents = shapePriorityStack;
        picturesContent.currentlySelected = this.currentlySelected;
        picturesContent.listeners = this.listeners;
        return picturesContent;
    }
}

