/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.drawing.shapes;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.SwingUtilities;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.plugins.drawing.elements.CurrentUsersMessage;
import nu.fw.jeti.plugins.drawing.elements.PictureMessage;
import nu.fw.jeti.plugins.drawing.geometry.Vector;
import nu.fw.jeti.plugins.drawing.shapes.PictureHistory;
import nu.fw.jeti.plugins.drawing.shapes.PicturesContent;
import nu.fw.jeti.plugins.drawing.shapes.Shape;
import nu.fw.jeti.plugins.drawing.shapes.TextShape;
import nu.fw.jeti.plugins.drawing.shapes.actions.Action;
import nu.fw.jeti.plugins.drawing.ui.HistoryPanel;
import nu.fw.jeti.plugins.drawing.ui.PictureChatFrame;
import nu.fw.jeti.plugins.drawing.ui.PictureFileFilter;
import nu.fw.jeti.plugins.drawing.ui.UserRepresentation;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PictureChat {
    private PictureChatFrame window;
    private Backend backend;
    private List<JID> receivers;
    private String thread;
    private List<PicturesContent> pictures;
    private PicturesContent currentPicture;
    private PictureHistory history;
    private Map<String, ImageWriter> writersMap;
    private boolean isBlockedChat = false;
    private List<Shape> staticClipboard = Collections.synchronizedList(new ArrayList());

    public PictureChat(Backend backend, JID jID, String string) {
        this.pictures = Collections.synchronizedList(new ArrayList());
        this.currentPicture = new PicturesContent();
        this.pictures.add(this.currentPicture);
        this.receivers = Collections.synchronizedList(new ArrayList());
        this.backend = backend;
        HistoryPanel historyPanel = new HistoryPanel(this);
        this.history = new PictureHistory(this.backend, historyPanel);
        this.receivers.add(jID);
        this.thread = string;
        this.window = new PictureChatFrame(this, this.currentPicture, historyPanel);
        this.window.setCurrentUsers(this.receivers);
        this.writersMap = this.createWritersMap();
        this.showWindow();
    }

    private Map<String, ImageWriter> createWritersMap() {
        Map<String, ImageWriter> map = Collections.synchronizedMap(new HashMap());
        List<String> list = PictureFileFilter.getAcceptedExt();
        for (String string : list) {
            ImageWriter imageWriter = this.getWriter(string);
            if (imageWriter == null) continue;
            map.put(string, imageWriter);
        }
        return map;
    }

    private ImageWriter getWriter(String string) {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public void newMessage(final PictureMessage pictureMessage) {
        if (this.isBlockedChat) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (pictureMessage instanceof CurrentUsersMessage) {
                    PictureChat.this.updateUsers(((CurrentUsersMessage)pictureMessage).getUsers());
                } else {
                    PictureChat.this.history.addIncomingMessage(pictureMessage, PictureChat.this.pictures);
                    PictureChat.this.showWindow();
                }
            }
        });
    }

    public void draw(Shape shape) {
        this.history.addShapeDrawnByMe(shape, this.getMyJID().toString(), this.pictures, this.receivers, this.thread);
    }

    public void delete(long l) {
        this.history.addDeletionDoneByMe(Action.createShapeIdList(l), this.getMyJID().toString(), this.pictures, this.receivers, this.thread);
    }

    public void undo() {
        this.history.undoMyAction(this.pictures, this.receivers, this.thread);
    }

    public void redo() {
        this.history.redoMyAction(this.pictures, this.receivers, this.thread);
    }

    public JID getJID() {
        return this.receivers.get(0);
    }

    public JID getMyJID() {
        return this.backend.getMyJID();
    }

    public void showWindow() {
        if (!this.window.isVisible()) {
            this.window.setVisible(true);
        }
        this.window.repaint();
    }

    public void selectItems(Point2D.Double double_, Point2D.Double double_2) {
        this.currentPicture.selectItems(double_, double_2);
    }

    public void selectItem(Point2D.Double double_, int n, int n2) {
        this.currentPicture.selectItem(double_, n, n2);
    }

    public void unselect() {
        this.currentPicture.unselect();
    }

    public boolean checkIfClickedInSelection(Point2D.Double double_, int n, int n2) {
        return this.currentPicture.checkIfClickedInSelection(double_, n, n2);
    }

    public void deleteSelectedShapes() {
        List<Long> list = this.currentPicture.getSelectedShapesIdList();
        this.currentPicture.unselect();
        this.history.addDeletionDoneByMe(list, this.getMyJID().toString(), this.pictures, this.receivers, this.thread);
    }

    public JID getAuthor(Point2D.Double double_, int n, int n2) {
        Shape shape = this.currentPicture.getShapeFromNeighbourhood(double_, n, n2);
        if (shape != null) {
            return shape.getAuthor();
        }
        return null;
    }

    public void moveShapes(Vector vector) {
        this.currentPicture.moveShapes(vector);
    }

    public void sendShapesTranslation(Vector vector) {
        this.history.addTranslationDoneByMe(this.currentPicture.getSelectedShapesIdList(), vector, this.getMyJID().toString(), this.pictures, this.receivers, this.thread);
    }

    public void addUsers(Set<UserRepresentation> set) {
        ArrayList<JID> arrayList = new ArrayList<JID>();
        for (UserRepresentation userRepresentation : set) {
            JID jID = userRepresentation.getJID();
            if (!this.thereIsNoSuchUserYet(jID)) continue;
            arrayList.add(jID);
        }
        if (!arrayList.isEmpty()) {
            this.history.sendAllHistory(arrayList, this.thread);
            this.receivers.addAll(arrayList);
            ArrayList arrayList2 = new ArrayList();
            arrayList2.addAll(this.receivers);
            arrayList2.add(this.getMyJID());
            this.history.sendCurrentUsers(this.getMyJID().toString(), arrayList2, this.receivers, this.thread);
        }
        this.window.setCurrentUsers(this.receivers);
    }

    public boolean thereIsNoSuchUserYet(JID jID) {
        if (jID.getUser() == null) {
            return false;
        }
        return !this.receivers.contains(jID) && !jID.getUser().equals(this.getMyJID().getUser());
    }

    public Backend getBackend() {
        return this.backend;
    }

    private void updateUsers(List<JID> list) {
        this.receivers = list;
        this.receivers.remove(this.getMyJID());
        this.window.setCurrentUsers(this.receivers);
    }

    public void setShapeColor(Color color) {
        this.history.addColorSetting(this.currentPicture.getSelectedShapesIdList(), this.getMyJID().toString(), color, this.pictures, this.receivers, this.thread);
    }

    public void setBackgroundColor(Color color) {
        Color color2 = this.currentPicture.getBackgroundColor();
        this.history.addBackgroundColorSetting(this.getMyJID().toString(), color2, color, this.pictures, this.receivers, this.thread);
    }

    public void clearBoard() {
        this.currentPicture.selectAll();
        this.deleteSelectedShapes();
        this.setBackgroundColor(PicturesContent.DEFAULT_BACKGROUND_COLOR);
    }

    public void selectAll() {
        this.currentPicture.selectAll();
    }

    public TextShape getClickedTextShape(Point2D.Double double_, int n, int n2) {
        return this.currentPicture.getClickedTextShape(double_, n, n2);
    }

    public void savePicture(File file, int n, int n2) {
        ImageWriter imageWriter = this.writersMap.get(PictureFileFilter.getExtension(file));
        if (imageWriter == null) {
            throw new IllegalArgumentException(new StringBuffer().append("PictureChat: File did not have a good extension: ").append(file).append(". For proper extentions").append(" look to PictureFileFilter").toString());
        }
        try {
            this.setWriterOutput(file, imageWriter);
        }
        catch (IOException iOException) {
            System.out.println("PictureChat: Unable to create an output stream.");
            return;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 5);
        Graphics graphics = bufferedImage.getGraphics();
        this.drawPicture(n, n2, graphics);
        try {
            imageWriter.write(bufferedImage);
        }
        catch (IOException iOException) {
            System.out.println("PictureChat: Unable to write BufferedImage on the ImageWriter.");
            return;
        }
    }

    private void setWriterOutput(File file, ImageWriter imageWriter) throws IOException {
        ImageOutputStream imageOutputStream = null;
        imageOutputStream = ImageIO.createImageOutputStream(file);
        imageWriter.setOutput(imageOutputStream);
    }

    private void drawPicture(int n, int n2, Graphics graphics) {
        graphics.setColor(this.window.getCurrentBackgroundColor());
        graphics.fillRect(0, 0, n, n2);
        this.currentPicture.drawPicture(graphics, n, n2);
    }

    public void copy() {
        this.staticClipboard.clear();
        this.staticClipboard.addAll(this.currentPicture.getCurrentlySelected());
    }

    public void paste() {
        if (!this.staticClipboard.isEmpty()) {
            Point2D.Double double_ = this.currentPicture.getTheMostUpperLeftPointAmongGaveList(this.staticClipboard);
            Vector vector = new Vector(-double_.x, -double_.y);
            this.history.addPasteDoneByMe(this.staticClipboard, vector, this.getMyJID().toString(), this.pictures, this.receivers, this.thread);
        }
    }

    public void blockChat() {
        this.isBlockedChat = true;
        this.receivers.clear();
    }

    public void cut() {
        this.staticClipboard.clear();
        this.staticClipboard.addAll(this.currentPicture.getCurrentlySelected());
        this.deleteSelectedShapes();
    }
}

