/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.drawing.shapes;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.plugins.drawing.geometry.PointsOperations;
import nu.fw.jeti.plugins.drawing.geometry.Vector;
import nu.fw.jeti.plugins.drawing.shapes.Shape;

public class Line
extends Shape {
    public static final String NAME = "line";
    private Point2D.Double start;
    private Point2D.Double end;

    public Line(long l, JID jID, String string, Color color, int n) {
        super(l, jID, color, n);
        this.setCoordinates(string);
    }

    public Line(Point2D.Double double_, Point2D.Double double_2, Color color, JID jID) {
        super(Line.generateId(), jID, color, -1);
        this.start = double_;
        this.end = double_2;
    }

    public void setCoordinates(String string) {
        List<Point2D.Double> list = PointsOperations.getPointsFromString(string);
        this.start = list.get(0);
        this.end = list.get(1);
    }

    public void draw(Graphics graphics, int n, int n2) {
        int n3 = this.ceil(this.start.x, n);
        int n4 = this.ceil(this.start.y, n2);
        int n5 = this.ceil(this.end.x, n);
        int n6 = this.ceil(this.end.y, n2);
        graphics.setColor(this.color);
        graphics.drawLine(n3, n4, n5, n6);
    }

    public String getCoordinates() {
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        arrayList.add(this.start);
        arrayList.add(this.end);
        return PointsOperations.pointsToString(arrayList);
    }

    public String getName() {
        return NAME;
    }

    public void drawAsSelected(Graphics graphics, int n, int n2) {
        this.draw(graphics, n, n2);
        int n3 = this.ceil(this.start.x, n);
        int n4 = this.ceil(this.start.y, n2);
        int n5 = this.ceil(this.end.x, n);
        int n6 = this.ceil(this.end.y, n2);
        graphics.setColor(this.selectionColor);
        graphics.drawRect(n3 - 2, n4 - 2, 4, 4);
        graphics.drawRect(n5 - 2, n6 - 2, 4, 4);
    }

    public boolean isInsideTheRect(Point2D.Double double_, Point2D.Double double_2) {
        return PointsOperations.pointIsInsideRect(this.start, double_, double_2) && PointsOperations.pointIsInsideRect(this.end, double_, double_2);
    }

    public boolean isPointInShapesNeighbourhood(Point2D.Double double_, int n, int n2) {
        return this.isPointInLinesNeighbourhood(this.start, this.end, double_, n, n2);
    }

    public Point2D.Double getDisplayPoint() {
        return PointsOperations.getMiddlePoint(this.start, this.end);
    }

    public void changeCoordinates(Vector vector) {
        this.start = vector.addVectorToPoint(this.start);
        this.end = vector.addVectorToPoint(this.end);
    }

    public Point2D.Double getTheMostUpperLeftPoint() {
        return new Point2D.Double(Math.min(this.start.x, this.end.x), Math.min(this.start.y, this.end.y));
    }

    public Point2D.Double getTheMostBottomRightPoint() {
        return new Point2D.Double(Math.max(this.start.x, this.end.x), Math.max(this.start.y, this.end.y));
    }

    public boolean isPointInShapesInterior(Point2D.Double double_, int n, int n2) {
        return false;
    }
}

