/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.drawing;

import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.handlers.ExtensionHandler;
import nu.fw.jeti.plugins.drawing.Plugin;
import nu.fw.jeti.plugins.drawing.elements.PictureMessageBuilder;
import nu.fw.jeti.util.Log;
import org.xml.sax.Attributes;

public class PictureMessageHandler
extends ExtensionHandler {
    private PictureMessageBuilder builder = new PictureMessageBuilder();

    public void startHandling(Attributes attributes) {
        this.builder.time = attributes.getValue("time");
        this.builder.counter = attributes.getValue("counter");
    }

    public void startElement(String string, Attributes attributes) {
        if (this.builder.messageType == -1) {
            if (string.equals("create")) {
                this.builder.messageType = 1;
            } else if (string.equals("display")) {
                this.builder.messageType = 2;
            } else if (string.equals("delete")) {
                this.builder.messageType = 3;
            } else if (string.equals("move")) {
                this.builder.messageType = 6;
            } else if (string.equals("color_set")) {
                this.builder.messageType = 4;
            } else if (string.equals("background")) {
                this.builder.messageType = 5;
            } else if (string.equals("current_users")) {
                this.builder.messageType = 15;
            }
        }
    }

    public void endElement(String string) {
        if (!string.equals("error")) {
            if (string.equals("actions_author")) {
                this.builder.actionsAuthor = this.getText();
            } else if (string.equals("thread")) {
                this.builder.thread = this.getText();
            } else if (string.equals("subject")) {
                this.builder.subject = this.getText();
            } else if (string.equals("shapeId")) {
                this.builder.shapeIdList = this.getText();
            } else {
                switch (this.builder.messageType) {
                    case 1: {
                        if (string.equals("color")) {
                            this.builder.color = this.getText();
                            break;
                        }
                        if (string.equals("author")) {
                            this.builder.shapesAuthor = this.getText();
                            break;
                        }
                        if (Plugin.shapeFactoryContains(string)) {
                            this.builder.shapeName = string;
                            this.builder.coord = this.getText();
                            break;
                        }
                        if (string.equals("height")) {
                            this.builder.shapeDisplayHeight = this.getText();
                            break;
                        }
                        if (string.equals("is_filled")) {
                            this.builder.isFilled = true;
                            break;
                        }
                        if (string.equals("create")) break;
                        this.notParsed(string, this.getText());
                        break;
                    }
                    case 2: {
                        if (string.equals("display")) break;
                        this.notParsed(string, this.getText());
                        break;
                    }
                    case 3: {
                        if (string.equals("delete")) break;
                        this.notParsed(string, this.getText());
                        break;
                    }
                    case 6: {
                        if (string.equals("move")) break;
                        if (string.equals("vector")) {
                            this.builder.transVector = this.getText();
                            break;
                        }
                        this.notParsed(string, this.getText());
                        break;
                    }
                    case 4: {
                        if (string.equals("color")) {
                            this.builder.color = this.getText();
                            break;
                        }
                        if (string.equals("color_set")) break;
                        this.notParsed(string, this.getText());
                        break;
                    }
                    case 5: {
                        if (string.equals("color")) {
                            this.builder.color = this.getText();
                            break;
                        }
                        if (string.equals("old_color")) {
                            this.builder.oldColor = this.getText();
                            break;
                        }
                        if (string.equals("background")) break;
                        this.notParsed(string, this.getText());
                        break;
                    }
                    case 15: {
                        if (string.equals("current_users")) {
                            this.builder.users = this.getText();
                            break;
                        }
                        this.notParsed(string, this.getText());
                        break;
                    }
                    default: {
                        this.notParsed(string, this.getText());
                    }
                }
            }
        }
        this.clearCurrentChars();
    }

    public Extension build() {
        this.clearCurrentChars();
        Extension extension = this.builder.build();
        this.builder.reset();
        return extension;
    }

    private void notParsed(String string, String string2) {
        Log.notParsedXML((String)("PictureMessageHandler: Unknown tag " + string + " with text: " + string2));
    }
}

