/*
 * Decompiled with CFR 0.152.
 */
package mil.jfcom.cie.media.srtp.packetizer;

import com.sun.media.codec.audio.AudioCodec;
import java.util.LinkedList;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import mil.jfcom.cie.media.session.MediaSession;
import mil.jfcom.cie.media.srtp.Logging;
import mil.jfcom.cie.media.srtp.packetizer.MDFEchoCanceller;
import mil.jfcom.cie.media.srtp.packetizer.Preprocessor;
import mil.jfcom.cie.media.srtp.packetizer.SpeexFormat;
import org.xiph.speex.Encoder;
import org.xiph.speex.SpeexEncoder;

public class SpeexPacketizer
extends AudioCodec {
    private static final int DRAIN_FRAMES = 3;
    private static int drainCount = 3;
    private static LinkedList lastPlayedBufferList = new LinkedList();
    private static final Format[] OUTPUT_FORMATS = new Format[]{SpeexFormat.SPEEX_RTP_FORMAT};
    static boolean echoWaiting;
    private MDFEchoCanceller echoCanceller;
    private SpeexEncoder encoder;
    private final float[] floatPCM;
    private int frameCount;
    private int frameSamples;
    private int frameSize;
    private short[] lastPlayBuffer;
    private int lastPlayIndex;
    private final byte[] leftover;
    private int leftoverCount;
    private final float[] noecho;
    private int noEchoFrames;
    private Preprocessor preprocessor;
    private Preprocessor preprocessorVAD;
    private final int[] residue;
    private long sequenceNumber;
    private int silentFrames;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static short[] getLastPlayBuffer() {
        if (lastPlayedBufferList.isEmpty()) {
            return null;
        }
        LinkedList linkedList = lastPlayedBufferList;
        synchronized (linkedList) {
            return (short[])lastPlayedBufferList.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addLastPlayBuffer(short[] played) {
        if (MediaSession.isMicrophoneOn()) {
            LinkedList linkedList;
            if (drainCount == 3) {
                linkedList = lastPlayedBufferList;
                synchronized (linkedList) {
                    echoWaiting = true;
                    while (true) {
                        try {
                            lastPlayedBufferList.wait(20L);
                            echoWaiting = false;
                        }
                        catch (InterruptedException e) {
                            Logging.LOG.debug((Object)"Wait() interrupted.", (Throwable)e);
                            continue;
                        }
                        break;
                    }
                }
            }
            linkedList = lastPlayedBufferList;
            synchronized (linkedList) {
                lastPlayedBufferList.add(played);
            }
        }
    }

    public SpeexPacketizer() {
        this.inputFormats = new Format[]{new AudioFormat("LINEAR", 8000.0, 16, 1, 0, 1, 2560, 100.0, Format.byteArray)};
        this.encoder = new SpeexEncoder();
        this.encoder.init(0, SpeexFormat.quality, 8000, 1);
        Encoder innerEnc = this.encoder.getEncoder();
        innerEnc.setVbr(true);
        innerEnc.setDtx(true);
        innerEnc.setVbrQuality((float)SpeexFormat.quality);
        this.frameSamples = this.encoder.getFrameSize();
        this.frameSize = 2 * this.frameSamples;
        this.floatPCM = new float[this.frameSamples];
        this.preprocessor = new Preprocessor(this.frameSamples, 8000);
        this.preprocessorVAD = new Preprocessor(this.frameSamples, 8000);
        this.preprocessorVAD.setVADEnabled(true);
        this.echoCanceller = new MDFEchoCanceller(this.frameSamples, 8000);
        this.leftover = new byte[this.frameSize];
        this.noecho = new float[this.frameSamples];
        this.residue = new int[this.frameSamples + 1];
    }

    public String getName() {
        return "Speex Packetizer";
    }

    public Format[] getSupportedOutputFormats(Format input) {
        return OUTPUT_FORMATS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int process(Buffer input, Buffer output) {
        int rc;
        block15: {
            rc = 1;
            byte[] inData = (byte[])input.getData();
            int inOffset = input.getOffset();
            int bytesLeft = input.getLength();
            try {
                block14: {
                    byte[] processed;
                    int encodedSize;
                    boolean endOfInput;
                    int framesPerPacket;
                    if (this.leftoverCount > 0) {
                        int fillLeftover = this.frameSize - this.leftoverCount;
                        System.arraycopy(inData, inOffset, this.leftover, this.leftoverCount, fillLeftover);
                        this.silentFrames = this.processAudio(this.leftover, 0) ? 0 : ++this.silentFrames;
                        ++this.frameCount;
                        inOffset += fillLeftover;
                        bytesLeft -= fillLeftover;
                        this.leftoverCount = 0;
                    }
                    boolean packetFilled = this.frameCount == (framesPerPacket = SpeexFormat.getFramesPerPacket());
                    boolean bl = endOfInput = bytesLeft < this.frameSize;
                    while (true) {
                        if (!packetFilled && !endOfInput) {
                            this.silentFrames = this.processAudio(inData, inOffset) ? 0 : ++this.silentFrames;
                            packetFilled = ++this.frameCount == framesPerPacket;
                            inOffset += this.frameSize;
                            endOfInput = (bytesLeft -= this.frameSize) < this.frameSize;
                            continue;
                        }
                        if (endOfInput && bytesLeft > 0) {
                            System.arraycopy(inData, inOffset, this.leftover, 0, bytesLeft);
                            this.leftoverCount = bytesLeft;
                        }
                        if (!packetFilled) break block14;
                        this.frameCount = 0;
                        encodedSize = this.encoder.getProcessedDataByteSize();
                        processed = new byte[encodedSize];
                        this.encoder.getProcessedData(processed, 0);
                        if (this.silentFrames < framesPerPacket) break;
                        if (endOfInput) {
                            rc = 4;
                            break block15;
                        }
                        this.silentFrames = 0;
                        packetFilled = false;
                    }
                    output.setData((Object)processed);
                    output.setOffset(0);
                    output.setLength(encodedSize);
                    output.setFormat((Format)SpeexFormat.SPEEX_RTP_FORMAT);
                    if (endOfInput) {
                        rc = 0;
                    } else {
                        rc = 2;
                        input.setOffset(inOffset);
                        input.setLength(bytesLeft);
                    }
                    output.setSequenceNumber(++this.sequenceNumber);
                    break block15;
                }
                rc = 4;
            }
            catch (Throwable e) {
                Logging.LOG.error((Object)"SpeexPacketizer ", e);
            }
        }
        if (echoWaiting) {
            LinkedList linkedList = lastPlayedBufferList;
            synchronized (linkedList) {
                lastPlayedBufferList.notify();
            }
        }
        if (drainCount == 0) {
            Thread.yield();
        }
        return rc;
    }

    private boolean processAudio(byte[] input, int offset) {
        SpeexEncoder.mapPcm16bitLittleEndian2Float((byte[])input, (int)offset, (float[])this.floatPCM, (int)0, (int)this.frameSamples);
        if (this.lastPlayBuffer == null) {
            this.lastPlayBuffer = SpeexPacketizer.getLastPlayBuffer();
        }
        float[] toPreprocess = this.floatPCM;
        int[] residuePreprocess = null;
        boolean resetProcessor = false;
        if (this.lastPlayBuffer != null) {
            this.noEchoFrames = 0;
            if (drainCount == 0) {
                this.echoCanceller.speexEchoCancel(this.floatPCM, this.lastPlayBuffer, this.lastPlayIndex, this.noecho, this.residue);
                this.lastPlayIndex += this.frameSamples;
                if (this.lastPlayIndex >= this.lastPlayBuffer.length) {
                    this.lastPlayBuffer = SpeexPacketizer.getLastPlayBuffer();
                    this.lastPlayIndex = 0;
                }
                toPreprocess = this.noecho;
                residuePreprocess = this.residue;
            } else if (--drainCount == 0) {
                resetProcessor = true;
            }
        } else if (this.noEchoFrames < 50) {
            ++this.noEchoFrames;
        } else {
            drainCount = 3;
        }
        this.preprocessor.speexPreprocess(toPreprocess, residuePreprocess);
        boolean isSpeech = this.preprocessorVAD.speexPreprocess(toPreprocess, null);
        if (resetProcessor) {
            this.echoCanceller = new MDFEchoCanceller(this.frameSamples, 8000);
        }
        this.encoder.processData(toPreprocess, this.frameSamples);
        return isSpeech;
    }
}

