/*
 * Decompiled with CFR 0.152.
 */
package mil.jfcom.cie.media.srtp.packetizer;

import mil.jfcom.cie.media.srtp.packetizer.SmallFT;

public class Preprocessor {
    private static final float[] HYPERGEOM_TABLE = new float[]{0.82157f, 1.02017f, 1.20461f, 1.37534f, 1.53363f, 1.68092f, 1.81865f, 1.94811f, 2.07038f, 2.18638f, 2.29688f, 2.40255f, 2.50391f, 2.60144f, 2.69551f, 2.78647f, 2.87458f, 2.96015f, 3.04333f, 3.12431f, 3.20326f};
    private static final int NB_BANDS = 8;
    private static final float NOISE_OVERCOMPENS = 1.4f;
    private static final float SPEEX_PROB_CONTINUE_DEFAULT = 0.2f;
    private static final float SPEEX_PROB_START_DEFAULT = 0.35f;
    static final float M_PI = (float)Math.PI;
    private int consecNoise;
    private boolean denoiseEnabled;
    private float[] echoNoise;
    private SmallFT fft;
    private float[] frame;
    private final int frameSize;
    private float[] gain;
    private float[] gain2;
    private float[] inbuf;
    private int lastSpeech;
    private float[] loudnessWeight;
    private float loudness2;
    private int nbAdapt;
    private int nbPreprocess;
    private float[] noise;
    private float[] noiseBands;
    private float[] noiseBands2;
    private int noiseBandsN;
    private float[] oldPs;
    private float[] outbuf;
    private float[] post;
    private float[] prior;
    private float[] ps;
    private final int psSize;
    private final float reverbDecay;
    private float[] reverbEstimate;
    private final float reverbLevel;
    private float[] ss;
    private final int samplingRate;
    private float[] smin;
    private float[] speechBands;
    private float[] speechBands2;
    private int speechBandsN;
    private float speechProb;
    private final float speechProbContinue;
    private final float speechProbStart;
    private float[] stmp;
    private float[] updateProb;
    private boolean vadEnabled;
    private float[] window;
    private float[] zeta;

    private static float hypergeomGain(float x) {
        if ((double)x > 9.5) {
            return 1.0f + 0.1296f / x;
        }
        float integer = (float)Math.floor(2.0f * x);
        float frac = 2.0f * x - integer;
        int ind = (int)integer;
        return ((1.0f - frac) * HYPERGEOM_TABLE[ind] + frac * HYPERGEOM_TABLE[ind + 1]) / (float)Math.sqrt((double)x + 1.0E-4);
    }

    public Preprocessor(int fSize, int samplingRate) {
        int i;
        int nN = this.psSize = (this.frameSize = fSize);
        int n3 = 2 * nN - this.frameSize;
        int n4 = this.frameSize - n3;
        this.samplingRate = samplingRate;
        this.denoiseEnabled = true;
        this.reverbDecay = 0.5f;
        this.reverbLevel = 0.2f;
        this.speechProbStart = 0.35f;
        this.speechProbContinue = 0.2f;
        this.frame = new float[2 * nN];
        this.ps = new float[nN];
        this.gain2 = new float[nN];
        this.window = new float[2 * nN];
        this.noise = new float[nN];
        this.reverbEstimate = new float[nN];
        this.oldPs = new float[nN];
        this.gain = new float[nN];
        this.prior = new float[nN];
        this.post = new float[nN];
        this.loudnessWeight = new float[nN];
        this.inbuf = new float[n3];
        this.outbuf = new float[n3];
        this.echoNoise = new float[nN];
        this.ss = new float[nN];
        this.smin = new float[nN];
        this.stmp = new float[nN];
        this.updateProb = new float[nN];
        this.zeta = new float[nN];
        this.noiseBands = new float[8];
        this.noiseBands2 = new float[8];
        this.speechBands = new float[8];
        this.speechBands2 = new float[8];
        this.speechBandsN = 1;
        this.noiseBandsN = 1;
        this.conjWindow(this.window, 2 * n3);
        for (i = 2 * n3; i < 2 * this.psSize; ++i) {
            this.window[i] = 1.0f;
        }
        if (n4 > 0) {
            for (i = n3 - 1; i >= 0; --i) {
                this.window[i + n3 + n4] = this.window[i + n3];
                this.window[i + n3] = 1.0f;
            }
        }
        for (i = 0; i < nN; ++i) {
            this.noise[i] = 10000.0f;
            this.reverbEstimate[i] = 0.0f;
            this.oldPs[i] = 10000.0f;
            this.gain[i] = 1.0f;
            this.post[i] = 1.0f;
            this.prior[i] = 1.0f;
        }
        for (i = 0; i < n3; ++i) {
            this.inbuf[i] = 0.0f;
            this.outbuf[i] = 0.0f;
        }
        for (i = 0; i < nN; ++i) {
            float ff = (float)i * 0.5f * (float)samplingRate / (float)nN;
            this.loudnessWeight[i] = 0.35f - 0.35f * ff / 16000.0f + 0.73f * (float)Math.exp(-0.5 * (double)(ff - 3800.0f) * (double)(ff - 3800.0f) / 900000.0);
            if (this.loudnessWeight[i] < 0.01f) {
                this.loudnessWeight[i] = 0.01f;
            }
            int n = i;
            this.loudnessWeight[n] = this.loudnessWeight[n] * this.loudnessWeight[i];
        }
        this.speechProb = 0.0f;
        this.lastSpeech = 1000;
        this.loudness2 = 6000.0f;
        this.fft = new SmallFT(2 * nN);
        this.nbAdapt = 0;
        this.consecNoise = 0;
        this.nbPreprocess = 0;
    }

    public void setVADEnabled(boolean enabled) {
        this.vadEnabled = enabled;
    }

    public boolean speexPreprocess(float[] x, int[] echoResidue) {
        int i;
        int i2;
        int i3;
        int i4;
        boolean isSpeech = true;
        float meanPost = 0.0f;
        float meanPrior = 0.0f;
        int nN = this.psSize;
        int n3 = 2 * nN - this.frameSize;
        int n4 = this.frameSize - n3;
        float scale = 0.5f / (float)nN;
        float zframe = 0.0f;
        this.preprocessAnalysis(x);
        this.updateNoiseProb();
        ++this.nbPreprocess;
        if (this.nbAdapt < 10) {
            this.updateNoise(this.ps, echoResidue);
        }
        if (echoResidue != null) {
            for (i4 = 1; i4 < nN; ++i4) {
                this.echoNoise[i4] = 0.3f * this.echoNoise[i4] + (float)(this.frameSize * this.frameSize) * 4.0f * (float)echoResidue[i4];
            }
        }
        for (i4 = 1; i4 < nN; ++i4) {
            float totNoise = 1.0f + 1.4f * this.noise[i4] + this.echoNoise[i4] + this.reverbEstimate[i4];
            this.post[i4] = this.ps[i4] / totNoise - 1.0f;
            if (this.post[i4] > 100.0f) {
                this.post[i4] = 100.0f;
            }
            meanPost += this.post[i4];
        }
        if ((meanPost /= (float)nN) < 0.0f) {
            meanPost = 0.0f;
        }
        if (this.nbAdapt == 1) {
            for (i4 = 1; i4 < nN; ++i4) {
                this.oldPs[i4] = this.ps[i4];
            }
        }
        for (i4 = 1; i4 < nN; ++i4) {
            float gamma = 0.1f + 0.9f * this.prior[i4] * this.prior[i4] / ((1.0f + this.prior[i4]) * (1.0f + this.prior[i4]));
            float totNoise = 1.0f + 1.4f * this.noise[i4] + this.echoNoise[i4] + this.reverbEstimate[i4];
            this.prior[i4] = gamma * Math.max(0.0f, this.post[i4]) + (1.0f - gamma) * (0.8f * this.gain[i4] * this.gain[i4] * this.oldPs[i4] / totNoise + 0.2f * this.prior[i4]);
            if (this.prior[i4] > 100.0f) {
                this.prior[i4] = 100.0f;
            }
            meanPrior += this.prior[i4];
        }
        meanPrior /= (float)nN;
        if (this.nbPreprocess >= 20) {
            boolean doUpdate = false;
            float noiseEner = 0.0f;
            float sigEner = 0.0f;
            if (meanPrior < 0.23f && meanPost < 0.5f) {
                doUpdate = true;
            }
            for (i3 = 1; i3 < nN; ++i3) {
                noiseEner += this.noise[i3];
                sigEner += this.ps[i3];
            }
            if (noiseEner > 3.0f * sigEner) {
                doUpdate = true;
            }
            this.consecNoise = doUpdate ? ++this.consecNoise : 0;
        }
        if (this.vadEnabled) {
            isSpeech = this.speexComputeVad(meanPrior, meanPost);
        }
        if (this.consecNoise >= 3) {
            this.updateNoise(this.oldPs, echoResidue);
        } else {
            for (i4 = 1; i4 < nN - 1; ++i4) {
                if (!(this.updateProb[i4] < 0.5f)) continue;
                this.noise[i4] = echoResidue != null ? 0.95f * this.noise[i4] + 0.05f * Math.max(1.0f, this.ps[i4] - (float)(this.frameSize * this.frameSize) * 4.0f * (float)echoResidue[i4]) : 0.95f * this.noise[i4] + 0.05f * this.ps[i4];
            }
        }
        for (i4 = 1; i4 < nN; ++i4) {
            this.zeta[i4] = 0.7f * this.zeta[i4] + 0.3f * this.prior[i4];
        }
        int freqStart = (int)(600.0f * (float)nN / (float)this.samplingRate);
        int freqEnd = (int)(4000.0f * (float)nN / (float)this.samplingRate);
        for (i2 = freqStart; i2 < freqEnd; ++i2) {
            zframe += this.zeta[i2];
        }
        float pframe = this.qcurve(zframe /= (float)(freqEnd - freqStart));
        for (i2 = 1; i2 < nN; ++i2) {
            float priorRatio = this.prior[i2] / (1.0001f + this.prior[i2]);
            float theta = (1.0f + this.post[i2]) * priorRatio;
            float zeta1 = i2 == 1 || i2 == nN - 1 ? this.zeta[i2] : 0.25f * this.zeta[i2 - 1] + 0.5f * this.zeta[i2] + 0.25f * this.zeta[i2 + 1];
            float p1 = this.qcurve(zeta1);
            float q = 1.0f - pframe * p1;
            q = 1.0f - p1;
            if (q > 0.95f) {
                q = 0.95f;
            }
            float p = 1.0f / (1.0f + q / (1.0f - q) * (1.0f + this.prior[i2]) * (float)Math.exp(-theta));
            float mm = Preprocessor.hypergeomGain(theta);
            this.gain[i2] = priorRatio * mm;
            if (this.gain[i2] > 2.0f) {
                this.gain[i2] = 2.0f;
            }
            this.reverbEstimate[i2] = this.reverbDecay * this.reverbEstimate[i2] + this.reverbDecay * this.reverbLevel * this.gain[i2] * this.gain[i2] * this.ps[i2];
            this.gain2[i2] = this.denoiseEnabled ? p * p * this.gain[i2] : 1.0f;
        }
        this.gain[0] = 0.0f;
        this.gain2[0] = 0.0f;
        this.gain[nN - 1] = 0.0f;
        this.gain2[nN - 1] = 0.0f;
        for (i2 = 1; i2 < nN; ++i2) {
            int n = 2 * i2 - 1;
            this.frame[n] = this.frame[n] * this.gain2[i2];
            int n2 = 2 * i2;
            this.frame[n2] = this.frame[n2] * this.gain2[i2];
        }
        this.frame[0] = 0.0f;
        this.frame[1] = 0.0f;
        this.frame[2] = 0.0f;
        this.frame[2 * nN - 1] = 0.0f;
        this.fft.spxDRFTbackward(this.frame);
        i2 = 0;
        while (i2 < 2 * nN) {
            int n = i2++;
            this.frame[n] = this.frame[n] * scale;
        }
        float maxSample = 0.0f;
        for (i3 = 0; i3 < 2 * nN; ++i3) {
            if (!(Math.abs(this.frame[i3]) > maxSample)) continue;
            maxSample = Math.abs(this.frame[i3]);
        }
        if (maxSample > 28000.0f) {
            float damp = 28000.0f / maxSample;
            int i5 = 0;
            while (i5 < 2 * nN) {
                int n = i5++;
                this.frame[n] = this.frame[n] * damp;
            }
        }
        for (i = 0; i < 2 * nN; ++i) {
            int n = i;
            this.frame[n] = this.frame[n] * this.window[i];
        }
        for (i = 0; i < n3; ++i) {
            x[i] = (short)(this.outbuf[i] + this.frame[i]);
        }
        for (i = 0; i < n4; ++i) {
            x[n3 + i] = (short)this.frame[n3 + i];
        }
        for (i = 0; i < n3; ++i) {
            this.outbuf[i] = this.frame[this.frameSize + i];
        }
        for (i = 1; i < nN; ++i) {
            this.oldPs[i] = this.ps[i];
        }
        return isSpeech;
    }

    private void conjWindow(float[] w, int len) {
        for (int i = 0; i < len; ++i) {
            float x = 4.0f * (float)i / (float)len;
            boolean inv = false;
            if (x >= 1.0f) {
                if (x < 2.0f) {
                    x = 2.0f - x;
                    inv = true;
                } else if (x < 3.0f) {
                    x -= 2.0f;
                    inv = true;
                } else {
                    x = 4.0f - x;
                }
            }
            x = (float)((double)x * 1.9979);
            w[i] = (float)((0.5 - 0.5 * Math.cos(x)) * (0.5 - 0.5 * Math.cos(x)));
            if (inv) {
                w[i] = 1.0f - w[i];
            }
            w[i] = (float)Math.sqrt(w[i]);
        }
    }

    private void preprocessAnalysis(float[] x) {
        int i;
        int nN = this.psSize;
        int n3 = 2 * nN - this.frameSize;
        int n4 = this.frameSize - n3;
        for (i = 0; i < n3; ++i) {
            this.frame[i] = this.inbuf[i];
        }
        for (i = 0; i < this.frameSize; ++i) {
            this.frame[n3 + i] = x[i];
        }
        for (i = 0; i < n3; ++i) {
            this.inbuf[i] = x[n4 + i];
        }
        for (i = 0; i < 2 * nN; ++i) {
            int n = i;
            this.frame[n] = this.frame[n] * this.window[i];
        }
        this.fft.spxDRFTforward(this.frame);
        this.ps[0] = 1.0f;
        for (i = 1; i < nN; ++i) {
            int i2 = 2 * i;
            this.ps[i] = 1.0f + this.frame[i2 - 1] * this.frame[i2 - 1] + this.frame[i2] * this.frame[i2];
        }
    }

    private float qcurve(float x) {
        return 1.0f / (1.0f + 0.1f / (x * x));
    }

    private boolean speexComputeVad(float meanPrior, float meanPost) {
        boolean isSpeech;
        block31: {
            int i;
            isSpeech = false;
            int nN = this.psSize;
            float scale = 0.5f / (float)nN;
            float[] bands = new float[8];
            float totLoudness = 0.0f;
            float x = (float)Math.sqrt(meanPost);
            for (i = 5; i < nN - 10; ++i) {
                totLoudness += scale * this.ps[i] * this.loudnessWeight[i];
            }
            for (i = 0; i < 8; ++i) {
                bands[i] = 10000.0f;
                for (int j = i * nN / 8; j < (i + 1) * nN / 8; ++j) {
                    int n = i;
                    bands[n] = bands[n] + this.ps[j];
                }
                bands[i] = (float)Math.log(bands[i]);
            }
            float p0 = 1.0f / (1.0f + (float)Math.exp(3.0 * (double)(1.5f - x)));
            float p1 = 1.0f - p0;
            if (this.noiseBandsN < 50 || this.speechBandsN < 50) {
                int i2;
                if (meanPost > 5.0f) {
                    int n = this.speechBandsN++;
                    float adapt = 1.0f / (float)n;
                    if (adapt < 0.005f) {
                        adapt = 0.005f;
                    }
                    for (i2 = 0; i2 < 8; ++i2) {
                        this.speechBands[i2] = (1.0f - adapt) * this.speechBands[i2] + adapt * bands[i2];
                        this.speechBands2[i2] = (1.0f - adapt) * this.speechBands2[i2] + adapt * (bands[i2] - this.speechBands[i2]) * (bands[i2] - this.speechBands[i2]);
                    }
                } else {
                    int n = this.noiseBandsN++;
                    float adapt = 1.0f / (float)n;
                    if (adapt < 0.005f) {
                        adapt = 0.005f;
                    }
                    for (i2 = 0; i2 < 8; ++i2) {
                        this.noiseBands[i2] = (1.0f - adapt) * this.noiseBands[i2] + adapt * bands[i2];
                        this.noiseBands2[i2] = (1.0f - adapt) * this.noiseBands2[i2] + adapt * (bands[i2] - this.noiseBands[i2]) * (bands[i2] - this.noiseBands[i2]);
                    }
                }
            }
            p1 = 1.0f;
            p0 = 1.0f;
            for (int i3 = 0; i3 < 8; ++i3) {
                float tmp2;
                float tmp1;
                float pr;
                float speechMean;
                float noiseMean;
                float noiseVar = this.noiseBands2[i3];
                float speechVar = this.speechBands2[i3];
                if (noiseVar < 0.1f) {
                    noiseVar = 0.1f;
                }
                if (speechVar < 0.1f) {
                    speechVar = 0.1f;
                }
                if (speechVar < 0.05f * speechVar) {
                    noiseVar = 0.05f * speechVar;
                }
                if (speechVar < 0.05f * noiseVar) {
                    speechVar = 0.05f * noiseVar;
                }
                if (bands[i3] < this.noiseBands[i3]) {
                    speechVar = noiseVar;
                }
                if (bands[i3] > this.speechBands[i3]) {
                    noiseVar = speechVar;
                }
                if ((noiseMean = this.noiseBands[i3]) < (speechMean = this.speechBands[i3]) - 5.0f) {
                    noiseMean = speechMean - 5.0f;
                }
                if ((pr = (tmp1 = (float)(Math.exp(-0.5 * (double)(bands[i3] - speechMean) * (double)(bands[i3] - speechMean) / (double)speechVar) / Math.sqrt((float)Math.PI * 2 * speechVar))) / (1.0E-25f + tmp1 + (tmp2 = (float)(Math.exp(-0.5 * (double)(bands[i3] - noiseMean) * (double)(bands[i3] - noiseMean) / (double)noiseVar) / Math.sqrt((float)Math.PI * 2 * noiseVar))))) > 0.999f) {
                    pr = 0.999f;
                }
                if (pr < 0.001f) {
                    pr = 0.001f;
                }
                p0 *= pr;
                p1 *= 1.0f - pr;
            }
            p0 = (float)Math.pow(p0, 0.2);
            p1 = (float)Math.pow(p1, 0.2);
            p0 *= 2.0f;
            p0 /= p1 + p0;
            if (this.lastSpeech > 20) {
                float tmp = (float)Math.sqrt(totLoudness) / this.loudness2;
                if (p0 > (tmp = 1.0f - (float)Math.exp(-10.0 * (double)tmp))) {
                    p0 = tmp;
                }
            }
            p1 = 1.0f - p0;
            float speechProb1 = 1.0f - this.speechProb;
            this.speechProb = (p0 *= 0.99f * this.speechProb + 0.01f * speechProb1) / (1.0E-25f + (p1 *= 0.01f * this.speechProb + 0.99f * speechProb1) + p0);
            if (this.speechProb > this.speechProbStart || this.lastSpeech < 20 && this.speechProb > this.speechProbContinue) {
                isSpeech = true;
                this.lastSpeech = 0;
            } else {
                ++this.lastSpeech;
                if (this.lastSpeech < 20) {
                    isSpeech = true;
                }
            }
            if (this.noiseBandsN <= 50 || this.speechBandsN <= 50) break block31;
            if (meanPost > 5.0f) {
                int n = this.speechBandsN++;
                float adapt = 1.0f / (float)n;
                if (adapt < 0.005f) {
                    adapt = 0.005f;
                }
                for (int i4 = 0; i4 < 8; ++i4) {
                    this.speechBands[i4] = (1.0f - adapt) * this.speechBands[i4] + adapt * bands[i4];
                    this.speechBands2[i4] = (1.0f - adapt) * this.speechBands2[i4] + adapt * (bands[i4] - this.speechBands[i4]) * (bands[i4] - this.speechBands[i4]);
                }
            } else {
                int n = this.noiseBandsN++;
                float adapt = 1.0f / (float)n;
                if (adapt < 0.005f) {
                    adapt = 0.005f;
                }
                for (int i5 = 0; i5 < 8; ++i5) {
                    this.noiseBands[i5] = (1.0f - adapt) * this.noiseBands[i5] + adapt * bands[i5];
                    this.noiseBands2[i5] = (1.0f - adapt) * this.noiseBands2[i5] + adapt * (bands[i5] - this.noiseBands[i5]) * (bands[i5] - this.noiseBands[i5]);
                }
            }
        }
        return isSpeech;
    }

    private void updateNoise(float[] ps2, int[] echo) {
        ++this.nbAdapt;
        float beta = 1.0f / (float)this.nbAdapt;
        if (beta < 0.05f) {
            beta = 0.05f;
        }
        if (echo == null) {
            for (int i = 0; i < this.psSize; ++i) {
                this.noise[i] = (1.0f - beta) * this.noise[i] + beta * ps2[i];
            }
        } else {
            for (int i = 0; i < this.psSize; ++i) {
                this.noise[i] = (1.0f - beta) * this.noise[i] + beta * Math.max(1.0f, ps2[i] - (float)(this.frameSize * this.frameSize) * 4.0f * (float)echo[i]);
            }
        }
    }

    private void updateNoiseProb() {
        int i;
        int nN = this.psSize;
        for (i = 1; i < nN - 1; ++i) {
            this.ss[i] = 100.0f + 0.8f * this.ss[i] + 0.05f * this.ps[i - 1] + 0.1f * this.ps[i] + 0.05f * this.ps[i + 1];
        }
        if (this.nbPreprocess < 1) {
            for (i = 1; i < nN - 1; ++i) {
                this.stmp[i] = this.ss[i] + 100.0f;
                this.smin[i] = this.stmp[i];
            }
        }
        if (this.nbPreprocess % 200 == 0) {
            for (i = 1; i < nN - 1; ++i) {
                this.smin[i] = Math.min(this.stmp[i], this.ss[i]);
                this.stmp[i] = this.ss[i];
            }
        } else {
            for (i = 1; i < nN - 1; ++i) {
                this.smin[i] = Math.min(this.smin[i], this.ss[i]);
                this.stmp[i] = Math.min(this.stmp[i], this.ss[i]);
            }
        }
        for (i = 1; i < nN - 1; ++i) {
            int n = i;
            this.updateProb[n] = this.updateProb[n] * 0.2f;
            if (!((double)this.ss[i] > 2.5 * (double)this.smin[i])) continue;
            int n2 = i;
            this.updateProb[n2] = this.updateProb[n2] + 0.8f;
        }
    }
}

