/*
 * Decompiled with CFR 0.152.
 */
package mil.jfcom.cie.media.srtp.data;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyManagementException;
import mil.jfcom.cie.media.srtp.SRTPUtil;
import mil.jfcom.cie.media.srtp.data.SRTPStream;

public class SRTPSendStream
extends SRTPStream {
    private byte lastSEQhi;

    public SRTPSendStream(Key ke, Key ka, byte[] ks, int ntag) throws GeneralSecurityException {
        super(ke, ka, ks, ntag);
    }

    public int process(byte[] rtpPacket, int inOffset, int length, byte[] outputSRTP, int outOffset) throws GeneralSecurityException {
        if (this.packetsUsingMasterKey > 0xFFFFFFFFFFFFL) {
            throw new KeyManagementException("Master key's max SRTP packet number of 2^48 has been exceeded.");
        }
        int posSSRC = inOffset + 8;
        int posSEQ = inOffset + 2;
        if (this.lastSEQhi == -1 && rtpPacket[posSEQ] == 0) {
            int newROC = SRTPUtil.bytes2int(this.roc, 0) + 1;
            SRTPUtil.int2bytes(newROC, this.roc, 0);
        }
        this.lastSEQhi = rtpPacket[posSEQ];
        byte[] iv = new byte[]{0, 0, 0, 0, rtpPacket[posSSRC++], rtpPacket[posSSRC++], rtpPacket[posSSRC++], rtpPacket[posSSRC], this.roc[0], this.roc[1], this.roc[2], this.roc[3], rtpPacket[posSEQ], rtpPacket[posSEQ + 1], 0, 0};
        SRTPUtil.xor(this.ks, iv, 0, this.ns, iv, 0);
        int hdrSize = 12 + (rtpPacket[inOffset] & 0xF) * 4;
        int encyptLen = length - hdrSize;
        SRTPUtil.runCipher(this.cipher, iv, rtpPacket, hdrSize + inOffset, encyptLen, outputSRTP, hdrSize + outOffset);
        System.arraycopy(rtpPacket, inOffset, outputSRTP, outOffset, hdrSize);
        this.mac.update(outputSRTP, outOffset, length);
        this.mac.update(this.roc);
        this.mac.doFinal(outputSRTP, length + outOffset);
        ++this.packetsUsingMasterKey;
        return length + this.ntag;
    }
}

