/*
 * Decompiled with CFR 0.152.
 */
package mil.jfcom.cie.media.srtp;

import java.net.DatagramSocket;
import java.net.InetAddress;
import javax.media.protocol.PushSourceStream;
import javax.media.rtp.OutputDataStream;
import javax.media.rtp.RTPConnector;
import mil.jfcom.cie.media.srtp.BaseProcessor;
import mil.jfcom.cie.media.srtp.RTPTransport;
import mil.jfcom.cie.media.srtp.SRTPEngine;
import mil.jfcom.cie.media.srtp.SRTPTransport;

public class SRTPConnector
implements RTPConnector {
    private RTPTransport controlTransport;
    private RTPTransport dataTransport;
    private int recvBufSize;
    private int sendBufSize;
    private SRTPEngine srtpEngine;

    public SRTPConnector(DatagramSocket[] localports, InetAddress remoteAddress, int remotePort, SRTPEngine srtpEngine) {
        if (srtpEngine == null) {
            this.dataTransport = new RTPTransport(localports[0], remoteAddress, remotePort);
            this.controlTransport = new RTPTransport(localports[1], remoteAddress, remotePort + 1);
        } else {
            this.srtpEngine = srtpEngine;
            this.dataTransport = new SRTPTransport(localports[0], remoteAddress, remotePort);
            this.controlTransport = new SRTPTransport(localports[1], remoteAddress, remotePort + 1);
        }
    }

    public void close() {
        this.dataTransport.close();
        this.controlTransport.close();
        this.dataTransport = null;
        this.controlTransport = null;
    }

    public PushSourceStream getControlInputStream() {
        return this.controlTransport;
    }

    public OutputDataStream getControlOutputStream() {
        return this.controlTransport;
    }

    public PushSourceStream getDataInputStream() {
        return this.dataTransport;
    }

    public OutputDataStream getDataOutputStream() {
        return this.dataTransport;
    }

    public int getLocalPort() {
        return this.dataTransport.getLocalPort();
    }

    public int getReceiveBufferSize() {
        return this.recvBufSize;
    }

    public double getRTCPBandwidthFraction() {
        return -1.0;
    }

    public double getRTCPSenderBandwidthFraction() {
        return -1.0;
    }

    public int getSendBufferSize() {
        return this.sendBufSize;
    }

    public void setReceiveBufferSize(int size) {
        this.recvBufSize = size;
    }

    public void setSendBufferSize(int size) {
        this.sendBufSize = size;
    }

    public void start() {
        BaseProcessor dataSendProcessor = null;
        BaseProcessor dataReceiveProcessor = null;
        BaseProcessor controlSendProcessor = null;
        BaseProcessor controlReceiveProcessor = null;
        if (this.srtpEngine != null) {
            dataSendProcessor = this.srtpEngine.getSRTPSendProcessor();
            dataReceiveProcessor = this.srtpEngine.getSRTPReceiveProcessor();
            controlSendProcessor = this.srtpEngine.getSRTCPSendProcessor();
            controlReceiveProcessor = this.srtpEngine.getSRTCPReceiveProcessor();
        }
        this.dataTransport.start(dataSendProcessor, dataReceiveProcessor);
        this.controlTransport.start(controlSendProcessor, controlReceiveProcessor);
    }
}

