/*
 * Decompiled with CFR 0.152.
 */
package mil.jfcom.cie.media.session;

import java.awt.Component;
import java.io.IOException;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Vector;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerAdapter;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoProcessorException;
import javax.media.NotConfiguredError;
import javax.media.NotRealizedError;
import javax.media.PlugInManager;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;
import javax.media.control.TrackControl;
import javax.media.format.UnsupportedFormatException;
import javax.media.protocol.ContentDescriptor;
import javax.media.rtp.GlobalReceptionStats;
import javax.media.rtp.GlobalTransmissionStats;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.RTPManager;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.RemoteListener;
import javax.media.rtp.SendStream;
import javax.media.rtp.rtcp.SourceDescription;
import mil.jfcom.cie.media.session.MediaSessionListener;
import mil.jfcom.cie.media.session.RTPEventHandler;
import mil.jfcom.cie.media.srtp.Logging;
import mil.jfcom.cie.media.srtp.SRTPConnector;
import mil.jfcom.cie.media.srtp.SRTPEngine;
import mil.jfcom.cie.media.srtp.packetizer.SpeexDepacketizer;
import mil.jfcom.cie.media.srtp.packetizer.SpeexFormat;

public final class MediaSession {
    private static boolean microphoneOn;
    private static SecureRandom rng;
    private static final String SESSION_ALREADY_CLOSED = "MediaSession object already closed.";
    private static final String SPEEX_DEPACKETIZER = "mil.jfcom.cie.media.srtp.packetizer.SpeexDepacketizer";
    private static final String SPEEX_PACKETIZER = "mil.jfcom.cie.media.srtp.packetizer.SpeexPacketizer";
    private static final int SPEEX_PAYLOAD_ID = 108;
    private Processor captureProcessor;
    private RTPEventHandler receiveListener;
    private RTPManager rtpManager;
    private SendStream sendStream;
    private SRTPConnector srtpConnector;
    private SRTPEngine srtpEngine;

    public static MediaSession createInstance(String remoteHost, int remoteDataPort, DatagramSocket[] localports, int soundQuality, boolean secure, byte[] masterKey, byte[] masterSalt) throws NoProcessorException, UnsupportedFormatException, IOException, GeneralSecurityException {
        return new MediaSession(remoteHost, remoteDataPort, localports, soundQuality, secure, masterKey, masterSalt);
    }

    public static byte[] generateMasterKey(boolean isSalt) throws NoSuchAlgorithmException {
        if (rng == null) {
            rng = SecureRandom.getInstance("SHA1PRNG");
        }
        int size = isSalt ? 14 : 16;
        byte[] keySalt = new byte[size];
        rng.nextBytes(keySalt);
        return keySalt;
    }

    public static DatagramSocket[] getLocalPorts(InetAddress localAddress, int localPortWanted) throws SocketException {
        SocketException bindFail = null;
        DatagramSocket[] sockPair = new DatagramSocket[2];
        for (int localPort = localPortWanted; localPort < 65535; localPort += 2) {
            try {
                if (localAddress == null) {
                    sockPair[0] = new DatagramSocket(localPort);
                    sockPair[1] = new DatagramSocket(localPort + 1);
                } else {
                    sockPair[0] = new DatagramSocket(localPort, localAddress);
                    sockPair[1] = new DatagramSocket(localPort + 1, localAddress);
                }
                return sockPair;
            }
            catch (SocketException e) {
                if (sockPair[0] != null) {
                    sockPair[0].close();
                }
                if (!(e instanceof BindException)) {
                    throw e;
                }
                bindFail = e;
                continue;
            }
        }
        throw bindFail;
    }

    public static boolean isMicrophoneOn() {
        return microphoneOn;
    }

    public static void setQuality(int qualilty) {
        SpeexFormat.setQuality(qualilty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaSession(String remoteHost, int remoteDataPort, DatagramSocket[] localPorts, int quality, boolean secure, byte[] masterKey, byte[] masterSalt) throws NoProcessorException, IOException, GeneralSecurityException, UnsupportedFormatException {
        if (localPorts == null || localPorts.length != 2 || localPorts[0] == null || localPorts[1] == null) {
            throw new IllegalArgumentException("To create MediaSession, parameter 'localPorts' cannot be null. Call getLocalPorts() first.");
        }
        SpeexFormat.setQuality(quality);
        try {
            CaptureDeviceInfo di;
            try {
                this.captureProcessor = Manager.createProcessor((MediaLocator)new MediaLocator("dsound://"));
            }
            catch (NoProcessorException e1) {
                Vector devices = CaptureDeviceManager.getDeviceList((Format)SpeexDepacketizer.LINEAR_FORMAT);
                if (devices.isEmpty()) {
                    throw new NoProcessorException("No microphone device available or JMF not installed.");
                }
                di = (CaptureDeviceInfo)devices.elementAt(0);
                Logging.LOG.info((Object)("Capture devices: " + devices.size() + " Use: " + di.getLocator()));
                this.captureProcessor = Manager.createProcessor((MediaLocator)di.getLocator());
            }
            this.captureProcessor.addControllerListener((ControllerListener)new ControllerAdapter(){

                public void configureComplete(ConfigureCompleteEvent evt) {
                    Logging.LOG.info((Object)"configureComplete");
                    this.resume((ControllerEvent)evt);
                }

                public void realizeComplete(RealizeCompleteEvent evt) {
                    Logging.LOG.info((Object)"realizeComplete");
                    this.resume((ControllerEvent)evt);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void resume(ControllerEvent evt) {
                    Object source;
                    Object object = source = evt.getSource();
                    synchronized (object) {
                        source.notify();
                    }
                }
            });
            this.captureProcessor.configure();
            long startTime = System.currentTimeMillis();
            di = this.captureProcessor;
            synchronized (di) {
                while (this.captureProcessor.getState() != 180) {
                    if (System.currentTimeMillis() - startTime > 10000L) {
                        throw new RuntimeException("Cannot configure capture device");
                    }
                    try {
                        this.captureProcessor.wait(10000L);
                    }
                    catch (InterruptedException e) {
                        Logging.LOG.info((Object)"Wait() interrupted.");
                    }
                }
            }
            this.captureProcessor.setContentDescriptor(new ContentDescriptor("raw"));
            TrackControl[] track = this.captureProcessor.getTrackControls();
            boolean encodingOk = false;
            for (int i1 = 0; i1 < track.length; ++i1) {
                if (!encodingOk) {
                    TrackControl formatControl = track[i1];
                    if (formatControl.setFormat((Format)SpeexFormat.SPEEX_RTP_FORMAT) == null) {
                        track[i1].setEnabled(false);
                        Logging.LOG.info((Object)("Track: " + track[i1].isEnabled()));
                        continue;
                    }
                    track[i1].setEnabled(true);
                    Logging.LOG.info((Object)("Track: " + track[i1].isEnabled()));
                    encodingOk = true;
                    continue;
                }
                track[i1].setEnabled(false);
                Logging.LOG.info((Object)("Track: " + track[i1].isEnabled()));
            }
            if (!encodingOk) {
                this.close();
                throw new RuntimeException("Microphone cannot be programmed to use Speex");
            }
            this.captureProcessor.realize();
            startTime = System.currentTimeMillis();
            Processor i1 = this.captureProcessor;
            synchronized (i1) {
                while (this.captureProcessor.getState() != 300) {
                    if (System.currentTimeMillis() - startTime > 10000L) {
                        throw new RuntimeException("Cannot realize capture device");
                    }
                    try {
                        this.captureProcessor.wait(10000L);
                    }
                    catch (InterruptedException e) {
                        Logging.LOG.info((Object)"Wait() interrupted.");
                    }
                }
            }
            InetAddress remoteAddr = InetAddress.getByName(remoteHost);
            if (secure) {
                this.srtpEngine = new SRTPEngine(masterKey, masterSalt);
            }
            this.srtpConnector = new SRTPConnector(localPorts, remoteAddr, remoteDataPort, this.srtpEngine);
            int dataPort = this.srtpConnector.getLocalPort();
            Logging.LOG.info((Object)("Create RTP session at local ports: " + dataPort + " " + (dataPort + 1)));
            this.receiveListener = new RTPEventHandler();
            this.rtpManager = RTPManager.newInstance();
            this.rtpManager.addFormat((Format)SpeexFormat.SPEEX_RTP_FORMAT, 108);
            this.rtpManager.addReceiveStreamListener((ReceiveStreamListener)this.receiveListener);
            this.rtpManager.addRemoteListener((RemoteListener)this.receiveListener);
            this.rtpManager.initialize((RTPConnector)this.srtpConnector);
            this.sendStream = this.rtpManager.createSendStream(this.captureProcessor.getDataOutput(), 0);
        }
        catch (NoProcessorException e) {
            Logging.LOG.info((Object)("E: " + (Object)((Object)e)));
            this.close();
            throw e;
        }
        catch (NotConfiguredError e) {
            Logging.LOG.info((Object)("E: " + (Object)((Object)e)));
            this.close();
            throw e;
        }
        catch (UnknownHostException e) {
            Logging.LOG.info((Object)("E: " + e));
            this.close();
            throw e;
        }
        catch (NotRealizedError e) {
            Logging.LOG.info((Object)("E: " + (Object)((Object)e)));
            this.close();
            throw e;
        }
        catch (IOException e) {
            Logging.LOG.info((Object)("E: " + e));
            this.close();
            throw e;
        }
        catch (GeneralSecurityException e) {
            Logging.LOG.info((Object)("E: " + e));
            this.close();
            throw e;
        }
    }

    public void close() {
        if (this.sendStream != null) {
            try {
                this.sendStream.stop();
                this.sendStream.close();
            }
            catch (Exception e) {
                Logging.LOG.error((Object)"Closing media stream", (Throwable)e);
            }
            this.sendStream = null;
        }
        if (this.captureProcessor != null) {
            try {
                this.captureProcessor.stop();
                this.captureProcessor.deallocate();
                this.captureProcessor.close();
            }
            catch (Exception e) {
                Logging.LOG.error((Object)"Closing microphone", (Throwable)e);
            }
            this.captureProcessor = null;
        }
        if (this.rtpManager != null) {
            try {
                this.rtpManager.dispose();
            }
            catch (Exception e) {
                Logging.LOG.error((Object)"Disposing RTP manager", (Throwable)e);
            }
            this.rtpManager = null;
        }
        this.srtpEngine = null;
        if (this.receiveListener != null) {
            this.receiveListener.close();
            this.receiveListener = null;
        }
        this.srtpConnector = null;
        this.receiveListener = null;
    }

    public String getAuthAlgorithmName() {
        if (this.srtpEngine == null) {
            throw new RuntimeException(SESSION_ALREADY_CLOSED);
        }
        return this.srtpEngine.getAuthAlgorithmName();
    }

    public String getEncryptionAlgorithmName() {
        if (this.srtpEngine == null) {
            throw new RuntimeException(SESSION_ALREADY_CLOSED);
        }
        return this.srtpEngine.getEncryptionAlgorithmName();
    }

    public GlobalReceptionStats getGlobalReceptionStats() {
        return this.rtpManager.getGlobalReceptionStats();
    }

    public GlobalTransmissionStats getGlobalTransmissionStats() {
        return this.rtpManager.getGlobalTransmissionStats();
    }

    public int getLocalDataPort() {
        if (this.srtpConnector != null) {
            return this.srtpConnector.getLocalPort();
        }
        return -1;
    }

    public Component getMicrophoneControlPanelComponent() {
        return this.captureProcessor.getControlPanelComponent();
    }

    public Collection getRemoteStreamPlayers() {
        if (this.receiveListener == null) {
            throw new RuntimeException(SESSION_ALREADY_CLOSED);
        }
        return this.receiveListener.getRemoteStreamPlayers();
    }

    public void setListener(MediaSessionListener listener) {
        if (this.receiveListener == null) {
            throw new RuntimeException(SESSION_ALREADY_CLOSED);
        }
        this.receiveListener.setListener(listener);
    }

    public void setMicrophoneOn(boolean on) {
        microphoneOn = on;
        if (this.captureProcessor == null) {
            throw new RuntimeException(SESSION_ALREADY_CLOSED);
        }
        if (on) {
            this.captureProcessor.start();
        } else {
            this.captureProcessor.stop();
        }
    }

    public void setSourceDescription(SourceDescription[] desc) {
        if (this.sendStream == null) {
            throw new RuntimeException(SESSION_ALREADY_CLOSED);
        }
        this.sendStream.setSourceDescription(desc);
    }

    public void start(boolean micOn) throws IOException {
        if (this.captureProcessor == null) {
            throw new RuntimeException(SESSION_ALREADY_CLOSED);
        }
        this.srtpConnector.start();
        this.sendStream.start();
        this.captureProcessor.start();
        microphoneOn = micOn;
        if (!micOn) {
            this.captureProcessor.stop();
        }
    }

    static {
        Format[] linearFormats = new Format[]{SpeexDepacketizer.LINEAR_FORMAT};
        Format[] speexFormats = new Format[]{SpeexFormat.SPEEX_RTP_FORMAT};
        if (!PlugInManager.addPlugIn((String)SPEEX_PACKETIZER, (Format[])linearFormats, (Format[])speexFormats, (int)2) || !PlugInManager.addPlugIn((String)SPEEX_DEPACKETIZER, (Format[])speexFormats, (Format[])linearFormats, (int)2)) {
            System.out.println("Cannot register codec classes mil.jfcom.cie.media.srtp.packetizer.SpeexPacketizer and mil.jfcom.cie.media.srtp.packetizer.SpeexDepacketizer");
        } else {
            System.out.println("Registered codec classes mil.jfcom.cie.media.srtp.packetizer.SpeexPacketizer and mil.jfcom.cie.media.srtp.packetizer.SpeexDepacketizer");
        }
    }
}

