/*
 * Decompiled with CFR 0.152.
 */
package mil.jfcom.cie.media.demo;

import java.util.Iterator;
import java.util.Vector;
import javax.media.rtp.rtcp.SenderReport;
import javax.media.rtp.rtcp.SourceDescription;
import mil.jfcom.cie.media.session.MediaSession;
import mil.jfcom.cie.media.session.MediaSessionListener;
import mil.jfcom.cie.media.session.StreamPlayer;
import mil.jfcom.cie.media.srtp.Logging;

public class SimpleEventHandler
implements MediaSessionListener {
    private MediaSession session;

    public void newStreamIdentified(StreamPlayer stream) {
        Logging.LOG.info((Object)("New Participant identified, stream " + stream.hashCode()));
        this.updateDescription(stream.getSourceDescription());
    }

    public void senderReportReceived(SenderReport report) {
        Logging.LOG.info((Object)"Sender Report");
        this.updateDescription(report.getSourceDescription());
    }

    public void streamClosed(StreamPlayer stream, boolean timeout) {
        Logging.LOG.info((Object)("Participant stream timeout " + stream.hashCode()));
        this.updateDescription(stream.getSourceDescription());
        if (this.session.getRemoteStreamPlayers().isEmpty()) {
            Logging.LOG.info((Object)"Stop talking...");
            this.session.close();
            System.exit(0);
        }
    }

    private void updateDescription(Vector sourceDescription) {
        Iterator iter = sourceDescription.iterator();
        while (iter.hasNext()) {
            SourceDescription desc = (SourceDescription)iter.next();
            Logging.LOG.info((Object)(desc.getType() + " " + desc.getDescription()));
        }
    }

    public void setSession(MediaSession session) {
        this.session = session;
    }
}

