/*
 * Decompiled with CFR 0.152.
 */
package mil.jfcom.cie.media.demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mil.jfcom.cie.media.demo.AudioTest;
import mil.jfcom.cie.media.demo.GUISessionHandler;
import mil.jfcom.cie.media.session.MediaSession;
import mil.jfcom.cie.media.srtp.packetizer.SpeexFormat;

public class DemoJFrame
extends JFrame {
    private JPanel buttonPanel;
    private JButton connectBtn;
    private JButton disconnectBtn;
    private JButton exitBtn;
    private JComboBox framesComb;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel localHostLabel;
    private JPanel localHostPanel;
    private JLabel localPortLabel;
    private JCheckBox muteCheckBox;
    private JPanel playerControlPanel;
    private JPanel playerPanel;
    private ButtonGroup protocolGroup;
    private JComboBox qualityComb;
    private JPanel radioPanel;
    private JRadioButton radioRTP;
    private JRadioButton radioSRTP;
    private JPanel remoteHostPanel;
    private JTextField remoteHostTf;
    private JTextField remotePortTf;
    private JPanel remoteUserInfoPanel;
    private JLabel remoteUserLabel;
    private JPanel sessControlPanel;
    private MediaSession session;
    private int remotePort;
    private String localhost = "127.0.0.1";

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new DemoJFrame(args[1], Integer.parseInt(args[2])).setVisible(true);
            }
        });
    }

    public DemoJFrame(String localhost, int remotePort) {
        this.remotePort = remotePort;
        this.localhost = localhost;
        this.initComponents();
        this.setLocation(300, 300);
        try {
            InetAddress localHost = InetAddress.getByName(localhost);
            this.localHostLabel.setText(localHost.getHostName() + " (" + localHost.getHostAddress() + ")");
            this.remotePortTf.setText(Integer.toString(remotePort));
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
        }
    }

    private void connectBtnActionPerformed(ActionEvent evt) {
        String portText = this.remotePortTf.getText();
        try {
            this.remotePort = Integer.parseInt(portText);
            SpeexFormat.setFramesPerPacket(this.framesComb.getSelectedIndex() + 1);
            System.out.println("Frames per packet: " + SpeexFormat.getFramesPerPacket());
            this.session = AudioTest.createSession(this.localhost, this.session.getLocalDataPort(), this.remoteHostTf.getText(), this.remotePort, new GUISessionHandler(this, this.playerControlPanel, this.remoteUserLabel), this.qualityComb.getSelectedIndex(), this.radioSRTP.isSelected(), !this.muteCheckBox.isSelected());
            this.localPortLabel.setText("Port: " + this.session.getLocalDataPort());
            this.localHostPanel.validate();
            this.connectBtn.setEnabled(false);
            this.disconnectBtn.setEnabled(true);
            this.framesComb.setEnabled(false);
            this.radioRTP.setEnabled(false);
            this.radioSRTP.setEnabled(false);
            this.exitBtn.setEnabled(false);
            this.framesComb.setEnabled(false);
            this.qualityComb.setEnabled(false);
            this.playerControlPanel.add(new JLabel("Talk: "));
            this.playerControlPanel.add(this.session.getMicrophoneControlPanelComponent());
            this.playerControlPanel.add(new JLabel("  Listen: "));
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, portText + " is not a valid port number", "Error", 0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e, "Error", 0);
        }
    }

    private void disconnectBtnActionPerformed(ActionEvent evt) {
        this.disconnect();
    }

    private void exitBtnActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void initComponents() {
        this.protocolGroup = new ButtonGroup();
        this.playerPanel = new JPanel();
        this.remoteUserInfoPanel = new JPanel();
        this.remoteUserLabel = new JLabel();
        this.playerControlPanel = new JPanel();
        this.sessControlPanel = new JPanel();
        this.localHostPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.localHostLabel = new JLabel();
        this.localPortLabel = new JLabel();
        this.remoteHostPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.remoteHostTf = new JTextField();
        this.jLabel3 = new JLabel();
        this.remotePortTf = new JTextField();
        this.jLabel4 = new JLabel();
        this.radioSRTP = new JRadioButton();
        this.radioRTP = new JRadioButton();
        this.radioPanel = new JPanel();
        this.jLabel5 = new JLabel();
        this.qualityComb = new JComboBox();
        this.jLabel6 = new JLabel();
        this.framesComb = new JComboBox();
        this.muteCheckBox = new JCheckBox();
        this.buttonPanel = new JPanel();
        this.connectBtn = new JButton();
        this.disconnectBtn = new JButton();
        this.exitBtn = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("SRTP Audio Demo");
        this.playerPanel.setLayout(new BorderLayout());
        this.playerPanel.setBorder(BorderFactory.createEtchedBorder());
        this.playerPanel.setMinimumSize(new Dimension(100, 100));
        this.remoteUserLabel.setHorizontalAlignment(0);
        this.remoteUserLabel.setPreferredSize(new Dimension(150, 20));
        this.remoteUserInfoPanel.add(this.remoteUserLabel);
        this.playerPanel.add((Component)this.remoteUserInfoPanel, "South");
        this.playerControlPanel.setPreferredSize(new Dimension(400, 30));
        this.playerPanel.add((Component)this.playerControlPanel, "Center");
        this.getContentPane().add((Component)this.playerPanel, "Center");
        this.sessControlPanel.setLayout(new GridLayout(4, 0));
        this.sessControlPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.localHostPanel.setLayout(new FlowLayout(0, 5, 0));
        this.jLabel2.setText("Local Host:");
        this.localHostPanel.add(this.jLabel2);
        this.localHostLabel.setPreferredSize(new Dimension(200, 15));
        this.localHostPanel.add(this.localHostLabel);
        this.localPortLabel.setPreferredSize(new Dimension(100, 15));
        this.localHostPanel.add(this.localPortLabel);
        this.sessControlPanel.add(this.localHostPanel);
        this.remoteHostPanel.setLayout(new FlowLayout(0, 5, 0));
        this.jLabel1.setText("Remote Host:");
        this.remoteHostPanel.add(this.jLabel1);
        this.remoteHostTf.setText("localhost");
        this.remoteHostTf.setPreferredSize(new Dimension(100, 20));
        this.remoteHostPanel.add(this.remoteHostTf);
        this.jLabel3.setText("  Port:");
        this.remoteHostPanel.add(this.jLabel3);
        this.remotePortTf.setPreferredSize(new Dimension(40, 20));
        this.remoteHostPanel.add(this.remotePortTf);
        this.jLabel4.setText("   Protocol:");
        this.remoteHostPanel.add(this.jLabel4);
        this.protocolGroup.add(this.radioSRTP);
        this.radioSRTP.setSelected(true);
        this.radioSRTP.setText("SRTP");
        this.radioSRTP.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radioSRTP.setMargin(new Insets(0, 0, 0, 0));
        this.remoteHostPanel.add(this.radioSRTP);
        this.protocolGroup.add(this.radioRTP);
        this.radioRTP.setText("RTP");
        this.radioRTP.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radioRTP.setMargin(new Insets(0, 0, 0, 0));
        this.remoteHostPanel.add(this.radioRTP);
        this.sessControlPanel.add(this.remoteHostPanel);
        this.radioPanel.setLayout(new FlowLayout(0));
        this.jLabel5.setText(" Sound Quality:");
        this.radioPanel.add(this.jLabel5);
        this.qualityComb.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"}));
        this.qualityComb.setSelectedIndex(10);
        this.qualityComb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DemoJFrame.this.qualityCombActionPerformed(evt);
            }
        });
        this.radioPanel.add(this.qualityComb);
        this.jLabel6.setText("   frames/packet:");
        this.radioPanel.add(this.jLabel6);
        this.framesComb.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"}));
        this.framesComb.setSelectedIndex(6);
        this.radioPanel.add(this.framesComb);
        this.muteCheckBox.setText("Mute");
        this.muteCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        this.muteCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.muteCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                DemoJFrame.this.muteCheckBoxStateChanged(evt);
            }
        });
        this.radioPanel.add(this.muteCheckBox);
        this.sessControlPanel.add(this.radioPanel);
        this.connectBtn.setText("Connect");
        this.connectBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DemoJFrame.this.connectBtnActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.connectBtn);
        this.disconnectBtn.setText("Disconnect");
        this.disconnectBtn.setEnabled(false);
        this.disconnectBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DemoJFrame.this.disconnectBtnActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.disconnectBtn);
        this.exitBtn.setText("Exit");
        this.exitBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DemoJFrame.this.exitBtnActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.exitBtn);
        this.sessControlPanel.add(this.buttonPanel);
        this.getContentPane().add((Component)this.sessControlPanel, "South");
        this.pack();
    }

    private void muteCheckBoxStateChanged(ChangeEvent evt) {
        if (this.session != null) {
            this.session.setMicrophoneOn(!this.muteCheckBox.isSelected());
        }
    }

    private void qualityCombActionPerformed(ActionEvent evt) {
        MediaSession.setQuality(this.qualityComb.getSelectedIndex());
    }

    synchronized void disconnect() {
        if (this.session != null) {
            this.playerControlPanel.removeAll();
            this.playerControlPanel.repaint();
            this.session.close();
            this.disconnectBtn.setEnabled(false);
            this.connectBtn.setEnabled(true);
            this.exitBtn.setEnabled(true);
            this.framesComb.setEnabled(true);
            this.radioRTP.setEnabled(true);
            this.radioSRTP.setEnabled(true);
            this.framesComb.setEnabled(true);
            this.qualityComb.setEnabled(true);
            this.localPortLabel.setText("");
            this.remoteUserLabel.setText("");
            this.session = null;
            System.out.println("Disconnected");
        }
    }
}

