/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.translate;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.plugins.Plugins;
import nu.fw.jeti.plugins.Translate;
import nu.fw.jeti.plugins.translate.BabelFishTranslator;
import nu.fw.jeti.plugins.translate.Direction;
import nu.fw.jeti.plugins.translate.TranslateWindow;
import nu.fw.jeti.ui.ChatSplitPane;
import nu.fw.jeti.util.I18N;

public class Plugin
implements Plugins,
Translate {
    public static final String VERSION = "0.1";
    public static final String DESCRIPTION = "translate.Translates_text_using_babelfish";
    public static final String MIN_JETI_VERSION = "0.7.6";
    public static final String NAME = "translate";
    public static final String ABOUT = "by E.S. de Boer, uses JTrans and babelfish";

    public void init(final ChatSplitPane chatSplitPane, final JTextPane jTextPane) {
        JMenu jMenu = new JMenu(I18N.gettext((String)"translate.Translate"));
        Direction[] directionArray = BabelFishTranslator.getSupportedDirections();
        for (int i = 0; i < directionArray.length; ++i) {
            JMenuItem jMenuItem = new JMenuItem(directionArray[i].toString());
            jMenuItem.setActionCommand(Integer.toString(i));
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    System.out.println(((JMenuItem)actionEvent.getSource()).getText());
                    int n = Integer.parseInt(actionEvent.getActionCommand());
                    try {
                        Direction direction = BabelFishTranslator.getSupportedDirections()[n];
                        String string = chatSplitPane.getSelectedText();
                        String string2 = URLEncoder.encode(string, "UTF-8");
                        String string3 = new BabelFishTranslator().translate(direction, string2, false, 100);
                        jTextPane.getDocument().insertString(jTextPane.getDocument().getLength(), string3, null);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        unsupportedEncodingException.printStackTrace();
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
            });
            jMenu.add(jMenuItem);
        }
        chatSplitPane.addToSelectedTextPopupMenu(jMenu);
    }

    public void translate(String string) {
        new TranslateWindow(string);
    }

    public static void init(Backend backend) {
    }

    public void unload() {
    }
}

