/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.spell;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import nu.fw.jeti.backend.Start;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.plugins.PreferencesPanel;
import nu.fw.jeti.plugins.spell.Plugin;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;
import nu.fw.jeti.util.TableSorter;

public class PrefPanel
extends PreferencesPanel {
    private BorderLayout borderLayout1 = new BorderLayout();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JTable jTable1;
    private JButton jButton1 = new JButton();
    private TableSorter sorter = new TableSorter(this.initTableModel());

    public PrefPanel(Backend backend) {
        this.jTable1 = new JTable((TableModel)this.sorter);
        this.sorter.setTableHeader(this.jTable1.getTableHeader());
        this.sorter.setSortingStatus(0, 1);
        this.jTable1.getColumnModel().getColumn(0).setPreferredWidth(60);
        this.jTable1.getColumnModel().getColumn(1).setPreferredWidth(15);
        this.jTable1.setDefaultRenderer(String.class, new MyTableRenderer());
        this.jTable1.setDefaultEditor(String.class, new MyTableEditor());
        this.jTable1.setRowSelectionAllowed(false);
        this.setLayout(this.borderLayout1);
        if (new File(Start.path + "dictionaries").exists()) {
            I18N.setTextAndMnemonic((String)"spell.Scan_Dictionaries", (AbstractButton)this.jButton1);
            this.jButton1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PrefPanel.this.jButton1_actionPerformed(actionEvent);
                }
            });
            this.add(this.jButton1, "South");
        }
        this.add(this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.jTable1, null);
    }

    private TableModel initTableModel() {
        String[] stringArray = Plugin.getLanguages();
        Object[][] objectArray = new Object[stringArray.length][3];
        String string = Preferences.getString((String)"spell", (String)"defaultLanguage", null);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].substring(0, stringArray[i].indexOf(46));
            Boolean bl = Boolean.valueOf(Preferences.getString((String)"spell", (String)string2, (String)"false"));
            String string3 = String.valueOf(string2.equals(string));
            objectArray[i] = new Object[]{string2, bl, string3};
        }
        if (string == null && stringArray.length > 0) {
            objectArray[0][2] = "true";
            objectArray[0][1] = Boolean.TRUE;
        }
        MyTableModel myTableModel = new MyTableModel(objectArray, new Object[]{I18N.gettext((String)"spell.Language"), I18N.gettext((String)"spell.Enabled"), I18N.gettext((String)"spell.Default")});
        return myTableModel;
    }

    void jButton1_actionPerformed(ActionEvent actionEvent) {
        Plugin.scanDictionaries();
        this.sorter.setTableModel(this.initTableModel());
    }

    public void savePreferences() {
        String[] stringArray = Plugin.getLanguages();
        block0: for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string = stringArray[i].substring(0, stringArray[i].indexOf(46));
            boolean bl = Preferences.getBoolean((String)"spell", (String)string, (boolean)false);
            for (n = 0; n < this.sorter.getRowCount(); ++n) {
                if (!string.equals(this.sorter.getValueAt(n, 0))) continue;
                boolean bl2 = (Boolean)this.sorter.getValueAt(n, 1);
                Preferences.putBoolean((String)"spell", (String)string, (boolean)bl2);
                if (!bl && bl2) {
                    Plugin.loadDictionary(stringArray[i]);
                    continue;
                }
                if (!bl || bl2) continue;
                Plugin.unloadDictionary(string);
            }
            for (n = 0; n < this.sorter.getRowCount(); ++n) {
                if (!this.sorter.getValueAt(n, 2).equals("true")) continue;
                Preferences.putString((String)"spell", (String)"defaultLanguage", (String)((String)this.sorter.getValueAt(n, 0)));
                continue block0;
            }
        }
    }

    static class MyTableEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JRadioButton radio = new JRadioButton();

        public MyTableEditor() {
            this.radio.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
                    if (!jRadioButton.isSelected()) {
                        jRadioButton.setSelected(true);
                    }
                    MyTableEditor.this.stopCellEditing();
                }
            });
        }

        public boolean isCellEditable(int n) {
            return n == 2;
        }

        public Object getCellEditorValue() {
            return String.valueOf(this.radio.isSelected());
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.radio.setBackground(jTable.getBackground());
            this.radio.setSelected(Boolean.valueOf((String)object));
            return this.radio;
        }
    }

    static class MyTableRenderer
    extends DefaultTableCellRenderer {
        private JRadioButton radio = new JRadioButton();

        public MyTableRenderer() {
            this.radio.setBackground(Color.white);
            this.radio.setAlignmentX(0.5f);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 == 2) {
                this.radio.setSelected(Boolean.valueOf((String)object));
                this.radio.setBackground(jTable.getBackground());
                return this.radio;
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    static class MyTableModel
    extends DefaultTableModel {
        public MyTableModel(Object[][] objectArray, Object[] objectArray2) {
            super(objectArray, objectArray2);
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 > 0;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 2) {
                if (object.equals("true")) {
                    for (int i = 0; i < this.getRowCount(); ++i) {
                        if (n == i) continue;
                        super.setValueAt("false", i, 2);
                    }
                    super.setValueAt("true", n, 2);
                } else {
                    super.setValueAt("false", n, 2);
                }
            } else {
                super.setValueAt(object, n, n2);
            }
        }
    }
}

