/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.XDataCallback;
import nu.fw.jeti.jabber.XDataPanel;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.jabber.elements.XData;
import nu.fw.jeti.jabber.elements.XDataField;
import nu.fw.jeti.plugins.search.IQSearch;
import nu.fw.jeti.plugins.search.JUDChooser;
import nu.fw.jeti.ui.AddContact;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Utils;

public class SearchWindow
extends JFrame
implements XDataCallback {
    private JPanel jPanel2 = new JPanel();
    private JButton btnOK = new JButton();
    private JButton btnCancel = new JButton();
    private JPanel pnlInstructions = new JPanel();
    private JTextArea txtInstructions = new JTextArea();
    private JLabel jLabel1 = new JLabel();
    private String key;
    private Map map;
    private Backend backend;
    private JID from;
    private String id;
    public static final int STRUT_SIZE = 5;
    private int current = 0;
    private List results;

    public SearchWindow(Backend backend, IQSearch iQSearch, JID jID, String string) {
        this.from = jID;
        this.id = string;
        this.backend = backend;
        XData xData = iQSearch.getXData();
        this.setDefaultCloseOperation(2);
        if (xData != null) {
            this.createXDataForm(xData);
        } else {
            this.oldSearch(iQSearch);
        }
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void createXDataForm(XData xData) {
        this.setIconImage(StatusIcons.getImageIcon((String)"jeti").getImage());
        if (xData.getTitle() != null) {
            this.setTitle(xData.getTitle());
        } else {
            this.setTitle(I18N.gettext((String)"search.User_Search"));
        }
        if (xData.getType().equals("form")) {
            this.setContentPane((Container)new XDataPanel(xData, (XDataCallback)this));
        } else if (xData.hasItems() || xData.hasItems()) {
            final XDataPanel xDataPanel = new XDataPanel(xData, (XDataCallback)this);
            JPanel jPanel = new JPanel();
            JButton jButton = new JButton();
            I18N.setTextAndMnemonic((String)"search.Add_to_Roster", (AbstractButton)jButton);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JID jID = null;
                    String string = null;
                    Iterator iterator = xDataPanel.getCurrentField();
                    while (iterator.hasNext()) {
                        XDataField xDataField = (XDataField)iterator.next();
                        if ("jid".equals(xDataField.getVar())) {
                            jID = JID.jidFromString((String)xDataField.getValue());
                            continue;
                        }
                        if (!"nick".equals(xDataField.getVar())) continue;
                        string = xDataField.getValue();
                    }
                    if (jID != null) {
                        new AddContact(jID, string, null, SearchWindow.this.backend).setVisible(true);
                    }
                }
            });
            jPanel.add(jButton);
            jButton = new JButton();
            I18N.setTextAndMnemonic((String)"search.Chat", (AbstractButton)jButton);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Iterator iterator = xDataPanel.getCurrentField();
                    while (iterator.hasNext()) {
                        XDataField xDataField = (XDataField)iterator.next();
                        if (!"jid".equals(xDataField.getVar())) continue;
                        JID jID = JID.jidFromString((String)xDataField.getValue());
                        SearchWindow.this.backend.getMain().startChat(jID);
                    }
                }
            });
            jPanel.add(jButton);
            this.getContentPane().add((Component)xDataPanel, "Center");
            this.getContentPane().add((Component)jPanel, "South");
        } else {
            this.getRootPane().setDefaultButton(this.btnOK);
            I18N.setTextAndMnemonic((String)"search.Search_Again", (AbstractButton)this.btnOK);
            this.btnOK.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SearchWindow.this.dispose();
                    new JUDChooser(SearchWindow.this.backend);
                }
            });
            this.getContentPane().add((Component)new JLabel(I18N.gettext((String)"search.No_User_Found,_try_with_different_search_terms")), "Center");
            this.getContentPane().add((Component)this.btnOK, "South");
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SearchWindow.this.cancelForm();
            }
        });
    }

    private void oldSearch(IQSearch iQSearch) {
        this.setIconImage(StatusIcons.getImageIcon((String)"jeti").getImage());
        this.setTitle(I18N.gettext((String)"search.User_Search"));
        List list = iQSearch.getList();
        if (list != null) {
            this.createMulti(list);
        } else if (iQSearch.getFields() != null) {
            Map map = iQSearch.getFields();
            this.map = new LinkedHashMap(15);
            this.key = (String)map.remove("key");
            this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 1));
            if (map.containsKey("instructions")) {
                String string = (String)map.remove("instructions");
                this.txtInstructions.setText(string);
                this.txtInstructions.setEnabled(false);
                this.jLabel1.setText(I18N.gettext((String)"main.register.Instructions"));
                this.jLabel1.setPreferredSize(new Dimension(80, 17));
                this.pnlInstructions.setLayout(new BorderLayout());
                this.pnlInstructions.add((Component)this.jLabel1, "West");
                this.pnlInstructions.add((Component)this.txtInstructions, "Center");
                this.jPanel2.add(Box.createVerticalStrut(5));
                this.jPanel2.add(this.pnlInstructions);
            }
            this.getContentPane().add((Component)this.jPanel2, "Center");
            this.jbInit(false);
            this.makeForm(map, this.jPanel2);
        } else {
            this.getContentPane().add((Component)new JLabel(I18N.gettext((String)"search.No_User_Found,_try_with_different_search_terms")), "Center");
            this.jbInit(true);
        }
    }

    private void makeForm(Map map, JPanel jPanel) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            JTextField jTextField = new JTextField();
            jTextField.setText((String)entry.getValue());
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            if (this.map != null) {
                this.map.put(entry.getKey(), jTextField);
            }
            JLabel jLabel = new JLabel((String)entry.getKey());
            jLabel.setPreferredSize(new Dimension(80, 17));
            jPanel2.add((Component)jLabel, "West");
            jPanel2.add((Component)jTextField, "Center");
            jPanel.add(Box.createVerticalStrut(5));
            jPanel.add(jPanel2);
        }
    }

    private void createMulti(final List list) {
        this.results = list;
        this.jbInit(true);
        if (list.size() > 1) {
            JPanel jPanel = new JPanel();
            final JButton jButton = new JButton();
            final JButton jButton2 = new JButton();
            I18N.setTextAndMnemonic((String)"search.Previous", (AbstractButton)jButton2);
            jPanel.add((Component)jButton2, "East");
            final JLabel jLabel = new JLabel("1/" + list.size());
            jPanel.add((Component)jLabel, "Center");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (SearchWindow.this.current != 0) {
                        SearchWindow.this.current--;
                    }
                    if (SearchWindow.this.current == 0) {
                        jButton2.setEnabled(false);
                    }
                    if (SearchWindow.this.current == list.size() - 2) {
                        jButton.setEnabled(true);
                    }
                    jLabel.setText(SearchWindow.this.current + 1 + "/" + list.size());
                    SearchWindow.this.gotoPostion(list);
                }
            });
            I18N.setTextAndMnemonic((String)"search.Next", (AbstractButton)jButton);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (SearchWindow.this.current < list.size() - 1) {
                        SearchWindow.this.current++;
                    }
                    if (SearchWindow.this.current == list.size() - 1) {
                        jButton.setEnabled(false);
                    }
                    if (SearchWindow.this.current == 1) {
                        jButton2.setEnabled(true);
                    }
                    jLabel.setText(SearchWindow.this.current + 1 + "/" + list.size());
                    SearchWindow.this.gotoPostion(list);
                }
            });
            jPanel.add((Component)jButton, "East");
            this.getContentPane().add((Component)jPanel, "North");
        }
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 1));
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.makeForm((Map)list.get(0), this.jPanel2);
    }

    private void gotoPostion(List list) {
        Map map = (Map)list.get(this.current);
        final JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.makeForm(map, jPanel);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchWindow.this.getContentPane().remove(SearchWindow.this.jPanel2);
                SearchWindow.this.jPanel2 = jPanel;
                SearchWindow.this.getContentPane().add((Component)SearchWindow.this.jPanel2, "Center");
                SearchWindow.this.validate();
            }
        });
    }

    private void jbInit(final boolean bl) {
        Serializable serializable;
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.getRootPane().setDefaultButton(this.btnOK);
        if (bl) {
            I18N.setTextAndMnemonic((String)"search.Search_Again", (AbstractButton)this.btnOK);
        }
        if (this.results != null) {
            serializable = new JButton();
            I18N.setTextAndMnemonic((String)"search.Add_to_Roster", (AbstractButton)serializable);
            ((AbstractButton)serializable).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Map map = (Map)SearchWindow.this.results.get(SearchWindow.this.current);
                    System.out.println("dfdf" + map.get("JID"));
                    JID jID = JID.jidFromString((String)((String)map.get("JID")));
                    if (jID == null) {
                        return;
                    }
                    new AddContact(jID, (String)map.get("nick"), null, SearchWindow.this.backend).setVisible(true);
                }
            });
            jPanel2.add((Component)serializable);
            serializable = new JButton();
            I18N.setTextAndMnemonic((String)"search.Chat", (AbstractButton)serializable);
            ((AbstractButton)serializable).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Map map = (Map)SearchWindow.this.results.get(SearchWindow.this.current);
                    System.out.println("dfdf" + map.get("JID"));
                    JID jID = JID.jidFromString((String)((String)map.get("JID")));
                    if (jID == null) {
                        return;
                    }
                    SearchWindow.this.backend.getMain().startChat(jID);
                }
            });
            jPanel2.add((Component)serializable);
            jPanel3.add((Component)jPanel2, "North");
        } else {
            I18N.setTextAndMnemonic((String)"OK", (AbstractButton)this.btnOK);
        }
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (bl) {
                    SearchWindow.this.dispose();
                    new JUDChooser(SearchWindow.this.backend);
                } else {
                    SearchWindow.this.btnOK_actionPerformed(actionEvent);
                }
            }
        });
        serializable = new AbstractAction(I18N.gettext((String)"Cancel")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (bl) {
                    SearchWindow.this.dispose();
                } else {
                    SearchWindow.this.btnCancel_actionPerformed(actionEvent);
                }
            }
        };
        Utils.addCancelButton((RootPaneContainer)this, (JButton)this.btnCancel, (Action)((Object)serializable));
        jPanel.add((Component)this.btnOK, null);
        jPanel.add((Component)this.btnCancel, null);
        jPanel3.add((Component)jPanel, "South");
        this.getContentPane().add((Component)jPanel3, "South");
    }

    void btnCancel_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    void btnOK_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.btnOK.setEnabled(false);
        this.btnCancel.setEnabled(false);
        LinkedHashMap linkedHashMap = new LinkedHashMap(16);
        Iterator iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = ((JTextField)entry.getValue()).getText().trim();
            if (string.equals("")) continue;
            linkedHashMap.put(entry.getKey(), string);
        }
        linkedHashMap.put("key", this.key);
        this.backend.send((Packet)new InfoQuery(this.from, "set", (IQExtension)new IQSearch(linkedHashMap)));
        this.dispose();
    }

    public void sendForm(XData xData) {
        this.backend.send((Packet)new InfoQuery(this.from, "set", this.id, (IQExtension)new IQSearch(xData)));
        this.dispose();
    }

    public void cancelForm() {
        this.dispose();
    }
}

