/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.vcard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.filechooser.FileFilter;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.plugins.Avatars;
import nu.fw.jeti.plugins.PluginsInfo;
import nu.fw.jeti.plugins.vcard.VCard;
import nu.fw.jeti.util.Base64;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.ImageFileFilter;
import nu.fw.jeti.util.Popups;
import nu.fw.jeti.util.Utils;

public class VCardEdit
extends JFrame {
    private Map personal;
    private Map business;
    private LinkedList personalFields;
    private LinkedList businessFields;
    private List homeTels;
    private List workTels;
    private Backend backend;
    private static int HOME = 1;
    private static int WORK = 2;
    private File photo = null;
    private File logo = null;

    public VCardEdit(Map map, Map map2, List list, List list2, Backend backend) {
        this.personal = map;
        this.business = map2;
        this.homeTels = list;
        this.workTels = list2;
        this.backend = backend;
        this.businessFields = new LinkedList();
        this.personalFields = new LinkedList();
        this.init();
    }

    private void init() {
        this.setTitle(I18N.gettext((String)"vcard.Edit_Details"));
        this.setIconImage(StatusIcons.getImageIcon((String)"jeti").getImage());
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(I18N.gettext((String)"vcard.Personal"), this.createPersonalPanel());
        jTabbedPane.addTab(I18N.gettext((String)"vcard.Business"), this.createBusinessPanel());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jTabbedPane, "Center");
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton();
        I18N.setTextAndMnemonic((String)"vcard.Submit", (AbstractButton)jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VCardEdit.this.submitVCard();
            }
        });
        jPanel.add(jButton);
        jButton = new JButton();
        AbstractAction abstractAction = new AbstractAction(I18N.gettext((String)"Cancel")){

            public void actionPerformed(ActionEvent actionEvent) {
                VCardEdit.this.dispose();
            }
        };
        Utils.addCancelButton((RootPaneContainer)this, (JButton)jButton, (Action)abstractAction);
        jPanel.add(jButton);
        this.getContentPane().add((Component)jPanel, "South");
        this.setDefaultCloseOperation(2);
        this.pack();
        int n = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        int n2 = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        if (this.getHeight() > n2) {
            this.setSize(n, this.getWidth());
        }
        if (this.getWidth() > n) {
            this.setSize(this.getHeight(), n2);
        }
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private JScrollPane createPersonalPanel() {
        Object object;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 5, 0, 3);
        String[] stringArray = (String[])this.personal.get("PHOTO");
        final JLabel jLabel = new JLabel();
        if (stringArray != null) {
            try {
                object = Base64.decode((String)stringArray[1]);
                jLabel.setIcon(new ImageIcon((byte[])object));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        object = new JButton();
        I18N.setTextAndMnemonic((String)"vcard.change_photo", (AbstractButton)object);
        ((AbstractButton)object).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VCardEdit.this.photo = VCardEdit.this.getImage();
                if (VCardEdit.this.photo != null) {
                    try {
                        jLabel.setIcon(new ImageIcon(VCardEdit.this.photo.toURL()));
                    }
                    catch (MalformedURLException malformedURLException) {
                        malformedURLException.printStackTrace();
                    }
                    VCardEdit.this.pack();
                }
            }
        });
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)object, gridBagConstraints);
        this.addLine("FN", HOME, jPanel, gridBagConstraints);
        this.addLine("GIVEN", HOME, jPanel, gridBagConstraints);
        this.addLine("MIDDLE", HOME, jPanel, gridBagConstraints);
        this.addLine("FAMILY", HOME, jPanel, gridBagConstraints);
        this.addLine("NICKNAME", HOME, jPanel, gridBagConstraints);
        this.addLine("BDAY", HOME, jPanel, gridBagConstraints);
        this.addAdress(HOME, jPanel, gridBagConstraints);
        if (this.homeTels != null) {
            this.addTel(HOME, jPanel, gridBagConstraints);
        }
        this.addLine("JABBERID", HOME, jPanel, gridBagConstraints);
        this.addLine("EMAIL", HOME, jPanel, gridBagConstraints);
        this.addLine("URL", HOME, jPanel, gridBagConstraints);
        this.addLine("DESC", HOME, jPanel, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        return new JScrollPane(jPanel);
    }

    private JScrollPane createBusinessPanel() {
        Object object;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 5, 0, 3);
        String[] stringArray = (String[])this.business.get("LOGO");
        final JLabel jLabel = new JLabel();
        if (stringArray != null) {
            try {
                object = Base64.decode((String)stringArray[1]);
                jLabel.setIcon(new ImageIcon((byte[])object));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        object = new JButton();
        I18N.setTextAndMnemonic((String)"vcard.change_photo", (AbstractButton)object);
        ((AbstractButton)object).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VCardEdit.this.logo = VCardEdit.this.getImage();
                if (VCardEdit.this.logo != null) {
                    try {
                        jLabel.setIcon(new ImageIcon(VCardEdit.this.logo.toURL()));
                    }
                    catch (MalformedURLException malformedURLException) {
                        malformedURLException.printStackTrace();
                    }
                    VCardEdit.this.pack();
                }
            }
        });
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)object, gridBagConstraints);
        if (this.workTels != null) {
            this.addTel(WORK, jPanel, gridBagConstraints);
        }
        this.addLine("TITLE", WORK, jPanel, gridBagConstraints);
        this.addLine("ROLE", WORK, jPanel, gridBagConstraints);
        this.addLine("ORGNAME", WORK, jPanel, gridBagConstraints);
        this.addLine("ORGUNIT", WORK, jPanel, gridBagConstraints);
        this.addLine("EMAIL", WORK, jPanel, gridBagConstraints);
        this.addAdress(WORK, jPanel, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        return new JScrollPane(jPanel);
    }

    private void addAdress(int n, JPanel jPanel, GridBagConstraints gridBagConstraints) {
        if (n == WORK) {
            this.addLine("POBOX", n, jPanel, gridBagConstraints);
        }
        this.addLine("STREET", n, jPanel, gridBagConstraints);
        this.addLine("EXTADR", n, jPanel, gridBagConstraints);
        this.addLine("LOCALITY", n, jPanel, gridBagConstraints);
        this.addLine("REGION", n, jPanel, gridBagConstraints);
        this.addLine("PCODE", n, jPanel, gridBagConstraints);
        this.addLine("CTRY", n, jPanel, gridBagConstraints);
    }

    private void addTel(int n, JPanel jPanel, GridBagConstraints gridBagConstraints) {
        LinkedList linkedList;
        List list;
        if (n == HOME) {
            list = this.homeTels;
            linkedList = this.personalFields;
        } else {
            list = this.workTels;
            linkedList = this.businessFields;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String[] stringArray = (String[])iterator.next();
            if (stringArray[0] == null) continue;
            this.addLine(stringArray[1], stringArray[0], jPanel, gridBagConstraints, linkedList);
        }
    }

    private void addLine(String string, String string2, JPanel jPanel, GridBagConstraints gridBagConstraints, List list) {
        gridBagConstraints.gridwidth = 1;
        JTextField jTextField = new JTextField(string2);
        list.add(new Object[]{string, jTextField});
        string = I18N.gettext((String)("vcard." + string));
        jPanel.add((Component)new JLabel(string), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)jTextField, gridBagConstraints);
    }

    private void addLine(String string, int n, JPanel jPanel, GridBagConstraints gridBagConstraints) {
        LinkedList linkedList;
        Map map;
        if (n == HOME) {
            map = this.personal;
            linkedList = this.personalFields;
        } else {
            map = this.business;
            linkedList = this.businessFields;
        }
        String string2 = (String)map.get(string);
        this.addLine(string, string2, jPanel, gridBagConstraints, linkedList);
    }

    private File getImage() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter((FileFilter)new ImageFileFilter());
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            if (jFileChooser.getSelectedFile().length() > 51200L) {
                Popups.errorPopup((String)I18N.gettext((String)"vcard.Image_may_not_be_larger_then_50kB"), (String)I18N.gettext((String)"vcard.Image_to_large"));
            } else {
                return jFileChooser.getSelectedFile();
            }
        }
        return null;
    }

    private void submitVCard() {
        String string;
        Object[] objectArray;
        HashMap<Object, String> hashMap = new HashMap<Object, String>(20);
        HashMap<Object, String> hashMap2 = new HashMap<Object, String>(20);
        Avatars avatars = this.personalFields.iterator();
        while (avatars.hasNext()) {
            objectArray = (Object[])avatars.next();
            string = ((JTextField)objectArray[1]).getText();
            if (string.equals("")) continue;
            hashMap.put(objectArray[0], string);
        }
        avatars = this.businessFields.iterator();
        while (avatars.hasNext()) {
            objectArray = (Object[])avatars.next();
            string = ((JTextField)objectArray[1]).getText();
            if (string.equals("")) continue;
            hashMap2.put(objectArray[0], string);
        }
        if (this.photo != null) {
            avatars = new String[2];
            avatars[1] = this.encode(this.photo);
            hashMap.put("PHOTO", (String)avatars);
        } else {
            hashMap.put("PHOTO", (String)this.personal.get("PHOTO"));
        }
        if (this.logo != null) {
            avatars = new String[2];
            avatars[1] = this.encode(this.logo);
            hashMap2.put("LOGO", (String)avatars);
        } else {
            hashMap2.put("LOGO", (String)this.business.get("LOGO"));
        }
        this.backend.send((Packet)new InfoQuery("set", (IQExtension)new VCard(hashMap, hashMap2, null, null)));
        if (PluginsInfo.isPluginLoaded((String)"ichatavatars")) {
            avatars = (Avatars)PluginsInfo.getPluginInstance((String)"ichatavatars");
            avatars.sendPresence();
        }
        this.dispose();
    }

    private String encode(File file) {
        FileInputStream fileInputStream = null;
        String string = null;
        try {
            fileInputStream = new FileInputStream(file.getAbsolutePath());
            int n = (int)file.length();
            byte[] byArray = new byte[n];
            ((InputStream)fileInputStream).read(byArray);
            if (PluginsInfo.isPluginLoaded((String)"ichatavatars")) {
                Avatars avatars = (Avatars)PluginsInfo.getPluginInstance((String)"ichatavatars");
                avatars.updateAvatar(byArray);
            }
            string = Base64.encodeBytes((byte[])byArray, (int)8);
            ((InputStream)fileInputStream).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }
}

