/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Log;
import nu.fw.jeti.util.Utils;

public class LogWindow
extends JFrame {
    private JPanel jPanel1 = new JPanel();
    private JButton btnClose = new JButton();
    private JButton btnRefresh = new JButton();
    private JTabbedPane jTabbedPane1 = new JTabbedPane();
    private JTextArea txtXML = new JTextArea();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JTextArea txtXMLErrors = new JTextArea();
    private JScrollPane jScrollPane2 = new JScrollPane();
    private JTextArea txtErrors = new JTextArea();
    private JScrollPane jScrollPane3 = new JScrollPane();
    private int xml;
    private int xmlErrors;
    private int errors;
    private Backend backend;

    public LogWindow(Backend backend) {
        this.backend = backend;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.txtXML.setText(I18N.gettext("main.log.Please_wait_loading_log"));
        Thread thread = new Thread(){

            public void run() {
                StringBuffer stringBuffer = new StringBuffer();
                List list = Log.getXML();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append(iterator.next());
                    stringBuffer.append("\n");
                }
                LogWindow.this.txtXML.setText(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                LogWindow.this.xml = list.size();
                list = Log.getXMLErrors();
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append(iterator.next());
                    stringBuffer.append("\n");
                }
                LogWindow.this.txtXMLErrors.setText(stringBuffer.toString());
                LogWindow.this.xmlErrors = list.size();
                list = Log.getErrors();
                stringBuffer = new StringBuffer();
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append(iterator.next());
                    stringBuffer.append("\n");
                }
                LogWindow.this.txtErrors.setText(stringBuffer.toString());
                LogWindow.this.errors = list.size();
            }
        };
        thread.setPriority(5);
        thread.start();
    }

    private void jbInit() throws Exception {
        this.jTabbedPane1.setBorder(null);
        this.setIconImage(StatusIcons.getImageIcon("jeti").getImage());
        this.setTitle(I18N.gettext("main.log.JETI_Log"));
        this.btnClose.setText(I18N.gettext("Close"));
        AbstractAction abstractAction = new AbstractAction(I18N.gettext("Close")){

            public void actionPerformed(ActionEvent actionEvent) {
                LogWindow.this.dispose();
            }
        };
        Utils.addCancelButton(this, this.btnClose, abstractAction);
        I18N.setTextAndMnemonic("main.log.Refresh", this.btnRefresh);
        this.btnRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogWindow.this.btnRefresh_actionPerformed(actionEvent);
            }
        });
        JButton jButton = new JButton();
        I18N.setTextAndMnemonic("main.log.Clear_Log", jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Log.clear();
                LogWindow.this.xml = 0;
                LogWindow.this.txtXML.setText("");
                LogWindow.this.btnRefresh_actionPerformed(actionEvent);
            }
        });
        JButton jButton2 = new JButton();
        I18N.setTextAndMnemonic("main.log.Send_XML", jButton2);
        this.setDefaultCloseOperation(2);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)jButton, null);
        this.jPanel1.add((Component)this.btnRefresh, null);
        this.jPanel1.add((Component)this.btnClose, null);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(I18N.gettext("main.log.Send_XML_to_the_Jabber_server,_use_this_at_your_own_risk")), "North");
        final JTextArea jTextArea = new JTextArea();
        jPanel.add((Component)new JScrollPane(jTextArea), "Center");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jTextArea.getText().indexOf("password") != -1) {
                    JOptionPane.showMessageDialog(LogWindow.this, I18N.gettext("main.log.For_security_reasons_it_is_not_possible_to_change_passwords,_please_use_the_jeti_functions_for_that"));
                } else if (jTextArea.getText().indexOf("remove") != -1) {
                    JOptionPane.showMessageDialog(LogWindow.this, I18N.gettext("main.log.For_security_reasons_it_is_not_possible_to_remove_accounts,_please_use_the_jeti_functions_for_that"));
                } else if (!jTextArea.getText().equals("")) {
                    LogWindow.this.backend.send(new Packet(){

                        public void appendToXML(StringBuffer stringBuffer) {
                            stringBuffer.append(jTextArea.getText());
                            jTextArea.setText("");
                        }
                    });
                }
            }
        });
        jPanel.add((Component)jButton2, "South");
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.jTabbedPane1.add((Component)this.jScrollPane1, I18N.gettext("main.log.XML"));
        this.jTabbedPane1.add((Component)this.jScrollPane2, I18N.gettext("main.log.XML_Errors"));
        this.jTabbedPane1.add((Component)this.jScrollPane3, I18N.gettext("main.log.Errors"));
        this.jTabbedPane1.add((Component)jPanel, I18N.gettext("main.log.Send_XML"));
        this.jScrollPane3.getViewport().add((Component)this.txtErrors, null);
        this.jScrollPane2.getViewport().add((Component)this.txtXMLErrors, null);
        this.jScrollPane1.getViewport().add((Component)this.txtXML, null);
        this.setSize(400, 400);
        this.setLocationRelativeTo(null);
    }

    void btnRefresh_actionPerformed(ActionEvent actionEvent) {
        Thread thread = new Thread(){

            public void run() {
                List list = Log.getXML();
                StringBuffer stringBuffer = new StringBuffer();
                ListIterator listIterator = list.listIterator(LogWindow.this.xml);
                while (listIterator.hasNext()) {
                    stringBuffer.append(listIterator.next());
                    stringBuffer.append("\n");
                }
                LogWindow.this.xml = list.size();
                LogWindow.this.txtXML.append(stringBuffer.toString());
                list = Log.getXMLErrors();
                listIterator = list.listIterator(LogWindow.this.xmlErrors);
                while (listIterator.hasNext()) {
                    LogWindow.this.txtXMLErrors.append((String)listIterator.next() + "\n");
                }
                LogWindow.this.xmlErrors = list.size();
                list = Log.getErrors();
                listIterator = list.listIterator(LogWindow.this.errors);
                while (listIterator.hasNext()) {
                    LogWindow.this.txtErrors.append((String)listIterator.next() + "\n");
                }
                LogWindow.this.errors = list.size();
            }
        };
        thread.setPriority(5);
        thread.start();
    }
}

