/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.jabber;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import nu.fw.jeti.jabber.LabelValue;
import nu.fw.jeti.jabber.XDataCallback;
import nu.fw.jeti.jabber.elements.XData;
import nu.fw.jeti.jabber.elements.XDataBuilder;
import nu.fw.jeti.jabber.elements.XDataField;
import nu.fw.jeti.util.I18N;

public class XDataPanel
extends JPanel {
    private boolean editable;
    private List fields = new LinkedList();
    private XData xdata;
    private int current;

    public XDataPanel(XData xData, final XDataCallback xDataCallback) {
        JComponent jComponent;
        this.setLayout(new BorderLayout());
        this.xdata = xData;
        if (xData.getType().equals("form")) {
            this.editable = true;
            jComponent = new JPanel();
            JButton jButton = new JButton();
            I18N.setTextAndMnemonic("Send", jButton);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    XDataPanel.this.sendForm(xDataCallback);
                }
            });
            jComponent.add(jButton);
            JButton jButton2 = new JButton(I18N.gettext("Cancel"));
            jButton2.setMnemonic(27);
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    xDataCallback.cancelForm();
                }
            });
            jComponent.add(jButton2);
            this.add((Component)jComponent, "South");
        }
        if (xData.getInstructions() != null) {
            jComponent = new JTextArea(xData.getInstructions());
            ((JTextComponent)jComponent).setEditable(false);
            jComponent.setBackground(SystemColor.control);
            this.add((Component)jComponent, "North");
        }
        if (xData.hasItems()) {
            this.createMulti(xData.getItems());
        } else if (xData.hasFields()) {
            this.add((Component)new JScrollPane(this.createFieldsPanel(xData.getFields())), "Center");
        }
    }

    public Iterator getCurrentField() {
        if (this.xdata.hasItems()) {
            return ((List)this.xdata.getItems().get(this.current)).iterator();
        }
        return this.xdata.getFields();
    }

    private JPanel createFieldsPanel(Iterator iterator) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 5, 0, 3);
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            XDataField xDataField = (XDataField)iterator2.next();
            this.parseField(xDataField, jPanel, gridBagConstraints);
        }
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        return jPanel;
    }

    private void createMulti(final List list) {
        if (list.size() > 1) {
            JPanel jPanel = new JPanel();
            final JButton jButton = new JButton();
            final JButton jButton2 = new JButton();
            I18N.setTextAndMnemonic("search.Previous", jButton2);
            jPanel.add((Component)jButton2, "East");
            final JLabel jLabel = new JLabel("1/" + list.size());
            jPanel.add((Component)jLabel, "Center");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (XDataPanel.this.current != 0) {
                        XDataPanel.this.current--;
                    }
                    if (XDataPanel.this.current == 0) {
                        jButton2.setEnabled(false);
                    }
                    if (XDataPanel.this.current == list.size() - 2) {
                        jButton.setEnabled(true);
                    }
                    jLabel.setText(XDataPanel.this.current + 1 + "/" + list.size());
                    XDataPanel.this.gotoPostion(list);
                }
            });
            I18N.setTextAndMnemonic("search.Next", jButton);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (XDataPanel.this.current < list.size() - 1) {
                        XDataPanel.this.current++;
                    }
                    if (XDataPanel.this.current == list.size() - 1) {
                        jButton.setEnabled(false);
                    }
                    if (XDataPanel.this.current == 1) {
                        jButton2.setEnabled(true);
                    }
                    jLabel.setText(XDataPanel.this.current + 1 + "/" + list.size());
                    XDataPanel.this.gotoPostion(list);
                }
            });
            jPanel.add((Component)jButton, "East");
            this.add((Component)jPanel, "North");
        }
        this.add((Component)new JScrollPane(this.createFieldsPanel(((List)list.get(0)).iterator())), "Center");
    }

    private void gotoPostion(List list) {
        final JPanel jPanel = this.createFieldsPanel(((List)list.get(this.current)).iterator());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                XDataPanel.this.add((Component)jPanel, "Center");
                XDataPanel.this.validate();
            }
        });
    }

    private void parseField(XDataField xDataField, JPanel jPanel, GridBagConstraints gridBagConstraints) {
        String string = xDataField.getType();
        String string2 = xDataField.getValue();
        String string3 = xDataField.getLabel();
        String string4 = xDataField.getDescription();
        boolean bl = xDataField.getRequired();
        String string5 = xDataField.getVar();
        if (string.equals("boolean")) {
            String string6 = string3 != null ? xDataField.getLabel() : string5;
            if (bl) {
                string6 = "*" + string6;
            }
            JCheckBox jCheckBox = new JCheckBox(string6);
            if ("0".equals(string2)) {
                jCheckBox.setSelected(false);
            }
            if ("1".equals(string2)) {
                jCheckBox.setSelected(true);
            }
            jCheckBox.setEnabled(this.editable);
            if (string4 != null) {
                jCheckBox.setToolTipText(string4);
            }
            jPanel.add((Component)jCheckBox, gridBagConstraints);
            jCheckBox.setName(string5);
            this.fields.add(jCheckBox);
        } else if (string.equals("fixed")) {
            JLabel jLabel = new JLabel(string2);
            jLabel.setAlignmentX(0.0f);
            if (string4 != null) {
                jLabel.setToolTipText(string4);
            }
            jLabel.setAlignmentX(0.0f);
            jPanel.add((Component)jLabel, gridBagConstraints);
        } else if (string.equals("list-multi")) {
            this.addLabel(string3, string5, string4, bl, jPanel, gridBagConstraints);
            JList jList = new JList();
            jList.setEnabled(this.editable);
            jPanel.add(jList, gridBagConstraints);
            jList.setAlignmentX(0.0f);
            jList.setName(string5);
            this.fields.add(jList);
        } else if (string.equals("list-single")) {
            this.addLabel(string3, string5, string4, bl, jPanel, gridBagConstraints);
            if (xDataField.hasOptions()) {
                Object[] objectArray = new Object[xDataField.getOptionsSize()];
                int n = 0;
                int n2 = 0;
                Object object = xDataField.getOptionsIterator();
                while (object.hasNext()) {
                    Object[] objectArray2 = (Object[])object.next();
                    objectArray[n] = new LabelValue(objectArray2);
                    if (((String)objectArray2[1]).equals(string2)) {
                        n2 = n;
                    }
                    ++n;
                }
                object = new JComboBox<Object>(objectArray);
                ((JComboBox)object).setSelectedIndex(n2);
                ((JComboBox)object).setEditable(this.editable);
                ((JComponent)object).setAlignmentX(0.0f);
                jPanel.add((Component)object, gridBagConstraints);
                ((Component)object).setName(string5);
                this.fields.add(object);
            }
        } else if (string.equals("text-multi")) {
            this.addLabel(string3, string5, string4, bl, jPanel, gridBagConstraints);
            JTextArea jTextArea = new JTextArea(string2, 2, 20);
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            jTextArea.setEditable(this.editable);
            jTextArea.setAlignmentX(0.0f);
            jPanel.add((Component)jScrollPane, gridBagConstraints);
            jTextArea.setName(string5);
            this.fields.add(jTextArea);
        } else if (string.equals("text-private")) {
            this.addLabel(string3, string5, string4, bl, jPanel, gridBagConstraints);
            JPasswordField jPasswordField = new JPasswordField(string2);
            jPasswordField.setEditable(this.editable);
            jPasswordField.setAlignmentX(0.0f);
            jPanel.add((Component)jPasswordField, gridBagConstraints);
            jPasswordField.setName(string5);
            this.fields.add(jPasswordField);
        } else if (string.equals("text-single")) {
            this.addLabel(string3, string5, string4, bl, jPanel, gridBagConstraints);
            JTextField jTextField = new JTextField(string2);
            jTextField.setEditable(this.editable);
            jTextField.setAlignmentX(0.0f);
            jPanel.add((Component)jTextField, gridBagConstraints);
            jTextField.setName(string5);
            this.fields.add(jTextField);
        } else if (string.equals("jid-multi")) {
            this.addLabel(string3, string5, string4, bl, jPanel, gridBagConstraints);
        } else if (string.equals("jid-single")) {
            this.addLabel(string3, string5, string4, bl, jPanel, gridBagConstraints);
        } else if (string.equals("hidden")) {
            this.fields.add(new Object[]{string5, string2});
        }
    }

    private void addLabel(String string, String string2, String string3, boolean bl, JPanel jPanel, GridBagConstraints gridBagConstraints) {
        String string4 = string != null ? string : string2;
        if (bl) {
            string4 = "*" + string4;
        }
        JLabel jLabel = new JLabel(string4);
        if (string3 != null) {
            jLabel.setToolTipText(string3);
        }
        jLabel.setAlignmentX(0.0f);
        jPanel.add((Component)jLabel, gridBagConstraints);
    }

    private void sendForm(XDataCallback xDataCallback) {
        XDataBuilder xDataBuilder = new XDataBuilder();
        xDataBuilder.type = "submit";
        Iterator iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            JList jList;
            Object e = iterator.next();
            String string = null;
            String string2 = null;
            if (e instanceof Object[]) {
                string = (String)((Object[])e)[0];
                string2 = (String)((Object[])e)[1];
                if (string2 == null) continue;
                xDataBuilder.addField(new XDataField(string, string2));
                continue;
            }
            JComponent jComponent = (JComponent)e;
            string = jComponent.getName();
            if (jComponent instanceof JCheckBox) {
                string2 = String.valueOf(((JCheckBox)jComponent).isSelected() ? 1 : 0);
            } else if (jComponent instanceof JTextComponent) {
                string2 = ((JTextComponent)jComponent).getText();
            } else if (jComponent instanceof JComboBox) {
                string2 = ((LabelValue)((JComboBox)jComponent).getSelectedItem()).value;
            }
            if (string2 != null) {
                xDataBuilder.addField(new XDataField(string, string2));
            }
            if (!(jComponent instanceof JList) || (jList = (JList)jComponent).isSelectionEmpty()) continue;
            Object[] objectArray = jList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                xDataBuilder.addField(new XDataField(string, ((LabelValue)objectArray[i]).value));
            }
        }
        try {
            xDataCallback.sendForm(xDataBuilder.build());
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
    }
}

