/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.backend;

import java.util.HashMap;
import java.util.Map;
import nu.fw.jeti.jabber.handlers.ExtensionHandler;
import nu.fw.jeti.jabber.handlers.IQAuthHandler;
import nu.fw.jeti.jabber.handlers.IQBrowseHandler;
import nu.fw.jeti.jabber.handlers.IQDiscoInfoHandler;
import nu.fw.jeti.jabber.handlers.IQDiscoItemsHandler;
import nu.fw.jeti.jabber.handlers.IQLastHandler;
import nu.fw.jeti.jabber.handlers.IQPrivateHandler;
import nu.fw.jeti.jabber.handlers.IQRegisterHandler;
import nu.fw.jeti.jabber.handlers.IQTimeHandler;
import nu.fw.jeti.jabber.handlers.IQVersionHandler;
import nu.fw.jeti.jabber.handlers.IQXCapsHandler;
import nu.fw.jeti.jabber.handlers.IQXOOBHandler;
import nu.fw.jeti.jabber.handlers.InfoQueryHandler;
import nu.fw.jeti.jabber.handlers.JetiPrivateHandler;
import nu.fw.jeti.jabber.handlers.JetiPrivateRosterHandler;
import nu.fw.jeti.jabber.handlers.MessageHandler;
import nu.fw.jeti.jabber.handlers.PacketHandler;
import nu.fw.jeti.jabber.handlers.PresenceHandler;
import nu.fw.jeti.jabber.handlers.RosterHandler;
import nu.fw.jeti.jabber.handlers.StreamErrorHandler;
import nu.fw.jeti.jabber.handlers.UnknownExtensionHandler;
import nu.fw.jeti.jabber.handlers.XDataHandler;
import nu.fw.jeti.jabber.handlers.XDelayHandler;
import nu.fw.jeti.jabber.handlers.XMPPErrorHandler;
import nu.fw.jeti.jabber.handlers.XMessageEventHandler;
import nu.fw.jeti.plugins.PluginsInfo;

public class Handlers {
    private Map handlers = new HashMap(10);
    private Map xmppHandlers;
    private InfoQueryHandler iqHandler = new InfoQueryHandler();
    private PresenceHandler presenceHandler = new PresenceHandler();
    private MessageHandler messageHandler = new MessageHandler();
    private StreamErrorHandler streamErrorHandler = new StreamErrorHandler();

    public Handlers() {
        this.handlers.put("jabber:iq:auth", new IQAuthHandler());
        this.handlers.put("jabber:iq:roster", new RosterHandler());
        this.handlers.put("jabber:iq:time", new IQTimeHandler());
        this.handlers.put("jabber:iq:version", new IQVersionHandler());
        this.handlers.put("jabber:iq:register", new IQRegisterHandler());
        this.handlers.put("j2m:prefs", new JetiPrivateHandler());
        this.handlers.put("jeti:rosterprefs", new JetiPrivateRosterHandler());
        this.handlers.put("jabber:iq:private", new IQPrivateHandler());
        this.handlers.put("jabber:x:event", new XMessageEventHandler());
        this.handlers.put("jabber:x:delay", new XDelayHandler());
        this.handlers.put("jabber:iq:browse", new IQBrowseHandler());
        this.handlers.put("jabber:iq:last", new IQLastHandler());
        this.handlers.put("jabber:iq:oob", new IQXOOBHandler());
        this.handlers.put("jabber:x:data", new XDataHandler());
        this.handlers.put("http://jabber.org/protocol/disco#info", new IQDiscoInfoHandler());
        this.handlers.put("http://jabber.org/protocol/disco#items", new IQDiscoItemsHandler());
        this.handlers.put("http://jabber.org/protocol/caps", new IQXCapsHandler());
        this.handlers.put("urn:ietf:params:xml:ns:xmpp-stanzas", new XMPPErrorHandler());
        this.handlers.put("urn:ietf:params:xml:ns:xmpp-streams", new XMPPErrorHandler());
        this.handlers.put("unknown", new UnknownExtensionHandler());
    }

    public void loadExtraHandlers(Map map) {
        if (PluginsInfo.isPluginLoaded("xmpp")) {
            this.xmppHandlers = map;
        }
    }

    public PacketHandler getPacketHandler(String string) {
        if ("iq".equals(string)) {
            return this.iqHandler;
        }
        if ("presence".equals(string)) {
            return this.presenceHandler;
        }
        if ("message".equals(string)) {
            return this.messageHandler;
        }
        if ("stream:error".equals(string)) {
            return this.streamErrorHandler;
        }
        if (this.xmppHandlers != null) {
            return (PacketHandler)this.xmppHandlers.get(string);
        }
        return null;
    }

    public synchronized ExtensionHandler getExtensionHandler(String string) {
        return (ExtensionHandler)this.handlers.get(string);
    }

    public synchronized void addExtensionHandler(String string, ExtensionHandler extensionHandler) {
        this.handlers.put(string, extensionHandler);
    }

    public synchronized void removeExtensionHandler(String string) {
        this.handlers.remove(string);
    }
}

