/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.compiere.util.MSort;

public class CTable
extends JTable {
    protected int p_lastSortIndex = -1;
    protected boolean p_asc = true;
    private final int SLACK = 15;
    private final int MAXSIZE = 250;
    protected int p_keyColumnIndex = -1;

    public CTable() {
        super(new DefaultTableModel());
        this.setColumnSelectionAllowed(false);
        this.setSelectionMode(0);
        this.setAutoResizeMode(0);
        this.getTableHeader().addMouseListener(new CTableMouseListener());
    }

    public void setKeyColumnIndex(int keyColumnIndex) {
        this.p_keyColumnIndex = keyColumnIndex;
    }

    public int getKeyColumnIndex() {
        return this.p_keyColumnIndex;
    }

    public Object getSelectedKeyColumnValue() {
        int row = this.getSelectedRow();
        if (row != -1 && this.p_keyColumnIndex != -1) {
            return this.getModel().getValueAt(row, this.p_keyColumnIndex);
        }
        return null;
    }

    public Object getSelectedValue() {
        int row = this.getSelectedRow();
        int col = this.getSelectedColumn();
        if (row == -1 || col == -1) {
            return null;
        }
        return this.getValueAt(row, col);
    }

    public void stopEditor(boolean saveValue) {
        ChangeEvent ce = new ChangeEvent(this);
        if (saveValue) {
            this.editingStopped(ce);
        } else {
            this.editingCanceled(ce);
        }
        if (this.getInputContext() != null) {
            this.getInputContext().endComposition();
        }
        this.transferFocus();
    }

    public void autoSize() {
        TableModel model = this.getModel();
        int size = model.getColumnCount();
        int c = 0;
        while (c < size) {
            TableColumn column = this.getColumnModel().getColumn(c);
            if (column.getIdentifier() != null && column.getMaxWidth() != 0 && column.getIdentifier().toString().length() != 0) {
                int width = 0;
                TableCellRenderer renderer = column.getHeaderRenderer();
                Component comp = null;
                if (renderer == null) {
                    renderer = new DefaultTableCellRenderer();
                } else {
                    comp = renderer.getTableCellRendererComponent(this, column.getHeaderValue(), false, false, 0, 0);
                }
                if (comp != null) {
                    width = comp.getPreferredSize().width + 15;
                    width = Math.max(width, comp.getWidth());
                    int col = column.getModelIndex();
                    int maxRow = Math.min(30, this.getRowCount());
                    try {
                        int row = 0;
                        while (row < maxRow) {
                            renderer = this.getCellRenderer(row, col);
                            comp = renderer.getTableCellRendererComponent(this, this.getValueAt(row, col), false, false, row, col);
                            int rowWidth = comp.getPreferredSize().width + 15;
                            width = Math.max(width, rowWidth);
                            ++row;
                        }
                    }
                    catch (Exception e) {
                        System.out.println(column.getIdentifier());
                        e.printStackTrace();
                    }
                    width = Math.min(250, width);
                }
                column.setPreferredWidth(width);
            }
            ++c;
        }
    }

    protected void sort(int modelColumnIndex) {
        int selCol;
        int rows = this.getRowCount();
        if (rows == 0) {
            return;
        }
        this.p_asc = modelColumnIndex != this.p_lastSortIndex ? true : !this.p_asc;
        this.p_lastSortIndex = modelColumnIndex;
        System.out.println("CTable.sort #" + modelColumnIndex + " - rows=" + rows + ", asc=" + this.p_asc);
        Object selected = null;
        int selRow = this.getSelectedRow();
        int n = selCol = this.p_keyColumnIndex == -1 ? 0 : this.p_keyColumnIndex;
        if (this.getSelectedRow() >= 0) {
            selected = this.getValueAt(selRow, selCol);
        }
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        MSort sort = new MSort(0, null);
        sort.setSortAsc(this.p_asc);
        block0: while (true) {
            ArrayList<MSort> sortList = new ArrayList<MSort>(rows);
            int i = 0;
            while (i < rows) {
                Object value = model.getValueAt(i, modelColumnIndex);
                sortList.add(new MSort(i, value));
                ++i;
            }
            Collections.sort(sortList, sort);
            int i2 = 0;
            while (i2 < rows) {
                int index = ((MSort)sortList.get((int)i2)).index;
                if (i2 != index) {
                    model.moveRow(i2, i2, index);
                    continue block0;
                }
                ++i2;
            }
            break;
        }
        this.clearSelection();
        if (selected != null) {
            int r = 0;
            while (r < rows) {
                if (selected.equals(this.getValueAt(r, selCol))) {
                    this.setRowSelectionInterval(r, r);
                    break;
                }
                ++r;
            }
        }
    }

    public String toString() {
        return "CTable[" + this.getModel() + "]";
    }

    class CTableMouseListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            int vc = CTable.this.getColumnModel().getColumnIndexAtX(e.getX());
            int mc = CTable.this.convertColumnIndexToModel(vc);
            CTable.this.sort(mc);
        }
    }
}

