/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.compiere.plaf.CompiereColor;
import org.compiere.plaf.CompierePLAF;
import org.compiere.plaf.CompierePanelUI;
import org.compiere.util.Trace;

public class CTabbedPane
extends JTabbedPane {
    public CTabbedPane() {
        this.init();
    }

    public CTabbedPane(int tabPlacement) {
        super(tabPlacement);
        this.init();
    }

    public CTabbedPane(int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
        this.init();
    }

    public CTabbedPane(CompiereColor bg) {
        this.init();
        this.setBackgroundColor(bg);
    }

    private void init() {
        this.setOpaque(false);
        this.setFont(CompierePLAF.getFont_Label());
        this.setForeground(CompierePLAF.getTextColor_Label());
    }

    public void setBackground(Color bg) {
        if (bg.equals(this.getBackground())) {
            return;
        }
        super.setBackground(bg);
        if (!Trace.getCallerClass(1).startsWith("javax")) {
            this.setBackgroundColor(new CompiereColor(bg));
        }
    }

    public void setBackgroundColor() {
        this.setBackgroundColor(null);
    }

    public void setBackgroundColor(CompiereColor bg) {
        if (bg == null) {
            bg = CompierePanelUI.getDefaultBackground();
        }
        this.setOpaque(true);
        this.putClientProperty("CompiereBackground", bg);
        super.setBackground(bg.getFlatColor());
        this.repaint();
    }

    public CompiereColor getBackgroundColor() {
        try {
            return (CompiereColor)this.getClientProperty("CompiereBackground");
        }
        catch (Exception e) {
            System.err.println("CPanel - ClientProperty: " + e.getMessage());
            return null;
        }
    }

    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        JPanel p;
        super.insertTab(title, icon, component, tip, index);
        if (component instanceof JPanel && (p = (JPanel)component).getClientProperty("CompiereBackground") == null) {
            CompiereColor.setBackground(p);
            p.setOpaque(true);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("CTabbedPane [");
        sb.append(super.toString());
        CompiereColor bg = this.getBackgroundColor();
        if (bg != null) {
            sb.append(bg.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

