/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.Color;
import javax.swing.JPasswordField;
import javax.swing.text.Document;
import org.compiere.plaf.CompierePLAF;
import org.compiere.swing.CEditor;

public class CPassword
extends JPasswordField
implements CEditor {
    private boolean m_mandatory = false;

    public CPassword() {
        this.init();
    }

    public CPassword(String text) {
        super(text);
        this.init();
    }

    public CPassword(int columns) {
        super(columns);
        this.init();
    }

    public CPassword(String text, int columns) {
        super(text, columns);
        this.init();
    }

    public CPassword(Document doc, String txt, int columns) {
        super(doc, txt, columns);
        this.init();
    }

    private void init() {
        this.setFont(CompierePLAF.getFont_Field());
        this.setForeground(CompierePLAF.getTextColor_Normal());
    }

    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
        this.setBackground(false);
    }

    public boolean isMandatory() {
        return this.m_mandatory;
    }

    public void setReadWrite(boolean rw) {
        if (super.isEditable() != rw) {
            super.setEditable(rw);
        }
        this.setBackground(false);
    }

    public boolean isReadWrite() {
        return super.isEditable();
    }

    public void setBackground(boolean error) {
        if (error) {
            this.setBackground(CompierePLAF.getFieldBackground_Error());
        } else if (!this.isReadWrite()) {
            this.setBackground(CompierePLAF.getFieldBackground_Inactive());
        } else if (this.m_mandatory) {
            this.setBackground(CompierePLAF.getFieldBackground_Mandatory());
        } else {
            this.setBackground(CompierePLAF.getFieldBackground_Normal());
        }
    }

    public void setBackground(Color bg) {
        if (bg.equals(this.getBackground())) {
            return;
        }
        super.setBackground(bg);
    }

    public void setValue(Object value) {
        if (value == null) {
            this.setText("");
        } else {
            this.setText(value.toString());
        }
    }

    public Object getValue() {
        return new String(super.getPassword());
    }

    public String getDisplay() {
        return new String(super.getPassword());
    }
}

