/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.compiere.plaf.CompierePLAF;

public class CLabel
extends JLabel {
    public static int DEFAULT_ALIGNMENT = 11;

    public CLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.init();
    }

    public CLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.init();
    }

    public CLabel(String text) {
        super(text, DEFAULT_ALIGNMENT);
        this.init();
    }

    public CLabel(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.init();
    }

    public CLabel(Icon image) {
        super(image, DEFAULT_ALIGNMENT);
        this.init();
    }

    public CLabel() {
        super("", DEFAULT_ALIGNMENT);
        this.init();
    }

    public CLabel(String label, String toolTip) {
        super(label, DEFAULT_ALIGNMENT);
        if (toolTip != null && toolTip.length() > 0) {
            super.setToolTipText(toolTip);
        }
        this.init();
    }

    private void init() {
        this.setFocusable(false);
        this.setOpaque(false);
        this.setForeground(CompierePLAF.getTextColor_Label());
        this.setFont(CompierePLAF.getFont_Label());
    }

    public void setBackground(Color bg) {
        if (bg.equals(this.getBackground())) {
            return;
        }
        super.setBackground(bg);
    }

    public void setText(String mnemonicLabel) {
        super.setText(this.createMnemonic(mnemonicLabel));
    }

    public void setTextDirect(String label) {
        super.setText(label);
    }

    private String createMnemonic(String text) {
        char ch;
        if (text == null) {
            return text;
        }
        int pos = text.indexOf("&");
        if (pos != -1 && (ch = text.charAt(pos + 1)) != ' ') {
            this.setDisplayedMnemonic(ch);
            return text.substring(0, pos) + text.substring(pos + 1);
        }
        return text;
    }

    public void setReadWrite(boolean rw) {
        this.setEnabled(rw);
    }
}

