/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.Color;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import org.compiere.plaf.CompiereColor;
import org.compiere.plaf.CompierePLAF;
import org.compiere.swing.CEditor;
import org.compiere.util.Trace;

public class CButton
extends JButton
implements CEditor {
    private boolean m_mandatory = false;
    private boolean m_readWrite = true;

    public CButton() {
        this(null, null);
    }

    public CButton(Icon icon) {
        this(null, icon);
    }

    public CButton(String text) {
        this(text, null);
    }

    public CButton(Action a) {
        super(a);
        this.setContentAreaFilled(false);
        this.setOpaque(false);
    }

    public CButton(String text, Icon icon) {
        super(text, icon);
        this.setContentAreaFilled(false);
        this.setOpaque(false);
        this.setFont(CompierePLAF.getFont_Label());
        this.setForeground(CompierePLAF.getTextColor_Label());
    }

    public void setBackground(Color bg) {
        if (bg.equals(this.getBackground())) {
            return;
        }
        super.setBackground(bg);
        if (!Trace.getCallerClass(1).startsWith("javax")) {
            this.setOpaque(true);
            this.setContentAreaFilled(true);
        }
        this.repaint();
    }

    public void setBackground(boolean error) {
    }

    public void setBackgroundColor() {
        this.setBackgroundColor(null);
    }

    public void setBackgroundColor(CompiereColor bg) {
        if (bg == null) {
            bg = CompiereColor.getDefaultBackground();
        }
        this.setOpaque(true);
        this.putClientProperty("CompiereBackground", bg);
        super.setBackground(bg.getFlatColor());
        this.repaint();
    }

    public CompiereColor getBackgroundColor() {
        try {
            return (CompiereColor)this.getClientProperty("CompiereBackground");
        }
        catch (Exception e) {
            System.err.println("CButton - ClientProperty: " + e.getMessage());
            return null;
        }
    }

    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
        this.setBackground(false);
    }

    public boolean isMandatory() {
        return this.m_mandatory;
    }

    public void setReadWrite(boolean rw) {
        if (super.isEnabled() != rw) {
            super.setEnabled(rw);
        }
        this.m_readWrite = rw;
    }

    public boolean isReadWrite() {
        return this.m_readWrite;
    }

    public void setValue(Object value) {
        if (value == null) {
            this.setText("");
        } else {
            this.setText(value.toString());
        }
    }

    public Object getValue() {
        return this.getText();
    }

    public String getDisplay() {
        return this.getText();
    }
}

