/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.plaf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.compiere.plaf.CompiereColor;
import org.compiere.plaf.CompiereLookAndFeel;
import org.compiere.plaf.CompierePLAF;
import org.compiere.plaf.CompiereTheme;
import org.compiere.plaf.FontChooser;
import org.compiere.swing.CButton;
import org.compiere.swing.CPanel;
import org.compiere.util.Ini;

public class CompiereThemeEditor
extends JDialog
implements ActionListener {
    static ResourceBundle s_res = ResourceBundle.getBundle("org.compiere.plaf.PlafRes");
    private CButton primary1 = new CButton();
    private CButton primary2 = new CButton();
    private CButton primary3 = new CButton();
    private CButton secondary1 = new CButton();
    private CButton secondary2 = new CButton();
    private CButton secondary3 = new CButton();
    private CButton controlFont = new CButton();
    private CButton systemFont = new CButton();
    private CButton userFont = new CButton();
    private CButton smallFont = new CButton();
    private CButton mandatory = new CButton();
    private CButton error = new CButton();
    private CButton windowFont = new CButton();
    private CButton menuFont = new CButton();
    private CButton white = new CButton();
    private CButton black = new CButton();
    private CPanel confirmPanel = new CPanel();
    private CButton inactive = new CButton();
    private CButton txt_ok = new CButton();
    private CButton txt_error = new CButton();
    private CButton bCancel = CompierePLAF.getCancelButton();
    private CButton bOK = CompierePLAF.getOKButton();
    private FlowLayout confirmLayout = new FlowLayout();
    private CPanel centerPanel = new CPanel();
    private CPanel metalColorPanel = new CPanel();
    private BorderLayout centerLayout = new BorderLayout();
    private CPanel compiereColorPanel = new CPanel();
    private TitledBorder metalColorBorder;
    private TitledBorder compiereColorBorder;
    private GridLayout metalColorLayout = new GridLayout();
    private GridLayout compiereColorLayout = new GridLayout();
    private CPanel fontPanel = new CPanel();
    private GridLayout fontLayout = new GridLayout();
    private TitledBorder fontBorder;
    private CButton info = new CButton();

    public CompiereThemeEditor(JDialog owner) {
        super(owner, s_res.getString("CompiereThemeEditor"), true);
        try {
            this.jbInit();
            this.loadTheme();
            this.dynInit();
            CompierePLAF.showCenterScreen(this);
        }
        catch (Exception e) {
            System.err.println("CompiereThemeEditor");
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        CompiereColor.setBackground(this);
        this.metalColorBorder = new TitledBorder(s_res.getString("MetalColors"));
        this.compiereColorBorder = new TitledBorder(s_res.getString("CompiereColors"));
        this.fontBorder = new TitledBorder(s_res.getString("CompiereFonts"));
        this.fontPanel.setBorder(this.fontBorder);
        this.fontPanel.setOpaque(false);
        this.setDefaultCloseOperation(2);
        this.primary1.setToolTipText(s_res.getString("Primary1Info"));
        this.primary1.setText(s_res.getString("Primary1"));
        this.primary1.addActionListener(this);
        this.primary2.setToolTipText(s_res.getString("Primary2Info"));
        this.primary2.setText(s_res.getString("Primary2"));
        this.primary2.addActionListener(this);
        this.primary3.setToolTipText(s_res.getString("Primary3Info"));
        this.primary3.setText(s_res.getString("Primary3"));
        this.primary3.addActionListener(this);
        this.secondary1.setToolTipText(s_res.getString("Secondary1Info"));
        this.secondary1.setText(s_res.getString("Secondary1"));
        this.secondary1.addActionListener(this);
        this.secondary2.setToolTipText(s_res.getString("Secondary2Info"));
        this.secondary2.setText(s_res.getString("Secondary2"));
        this.secondary2.addActionListener(this);
        this.secondary3.setToolTipText(s_res.getString("Secondary3Info"));
        this.secondary3.setText(s_res.getString("Secondary3"));
        this.secondary3.addActionListener(this);
        this.controlFont.setToolTipText(s_res.getString("ControlFontInfo"));
        this.controlFont.setText(s_res.getString("ControlFont"));
        this.controlFont.addActionListener(this);
        this.systemFont.setToolTipText(s_res.getString("SystemFontInfo"));
        this.systemFont.setText(s_res.getString("SystemFont"));
        this.systemFont.addActionListener(this);
        this.userFont.setToolTipText(s_res.getString("UserFontInfo"));
        this.userFont.setText(s_res.getString("UserFont"));
        this.userFont.addActionListener(this);
        this.smallFont.setText(s_res.getString("SmallFont"));
        this.smallFont.addActionListener(this);
        this.mandatory.setToolTipText(s_res.getString("MandatoryInfo"));
        this.mandatory.setText(s_res.getString("Mandatory"));
        this.mandatory.addActionListener(this);
        this.error.setToolTipText(s_res.getString("ErrorInfo"));
        this.error.setText(s_res.getString("Error"));
        this.error.addActionListener(this);
        this.info.setToolTipText(s_res.getString("InfoInfo"));
        this.info.setText(s_res.getString("Info"));
        this.info.addActionListener(this);
        this.windowFont.setText(s_res.getString("WindowTiteFont"));
        this.windowFont.addActionListener(this);
        this.menuFont.setText(s_res.getString("MenuFont"));
        this.menuFont.addActionListener(this);
        this.white.setToolTipText(s_res.getString("WhiteInfo"));
        this.white.setText(s_res.getString("White"));
        this.white.addActionListener(this);
        this.black.setToolTipText(s_res.getString("BlackInfo"));
        this.black.setText(s_res.getString("Black"));
        this.black.addActionListener(this);
        this.inactive.setToolTipText(s_res.getString("InactiveInfo"));
        this.inactive.setText(s_res.getString("Inactive"));
        this.inactive.addActionListener(this);
        this.txt_ok.setToolTipText(s_res.getString("TextOKInfo"));
        this.txt_ok.setText(s_res.getString("TextOK"));
        this.txt_ok.addActionListener(this);
        this.txt_error.setToolTipText(s_res.getString("TextIssueInfo"));
        this.txt_error.setText(s_res.getString("TextIssue"));
        this.txt_error.addActionListener(this);
        this.confirmPanel.setLayout(this.confirmLayout);
        this.confirmLayout.setAlignment(2);
        this.centerPanel.setLayout(this.centerLayout);
        this.metalColorPanel.setBorder(this.metalColorBorder);
        this.metalColorPanel.setOpaque(false);
        this.metalColorPanel.setLayout(this.metalColorLayout);
        this.compiereColorPanel.setLayout(this.compiereColorLayout);
        this.compiereColorPanel.setBorder(this.compiereColorBorder);
        this.compiereColorPanel.setOpaque(false);
        this.metalColorLayout.setColumns(3);
        this.metalColorLayout.setHgap(5);
        this.metalColorLayout.setRows(3);
        this.metalColorLayout.setVgap(5);
        this.compiereColorLayout.setColumns(4);
        this.compiereColorLayout.setHgap(5);
        this.compiereColorLayout.setRows(2);
        this.compiereColorLayout.setVgap(5);
        this.fontPanel.setLayout(this.fontLayout);
        this.fontLayout.setColumns(3);
        this.fontLayout.setHgap(5);
        this.fontLayout.setRows(2);
        this.fontLayout.setVgap(5);
        this.centerLayout.setVgap(5);
        this.fontBorder.setTitle(s_res.getString("Fonts"));
        this.confirmPanel.setOpaque(false);
        this.getContentPane().add((Component)this.confirmPanel, "South");
        this.confirmPanel.add((Component)this.bCancel, null);
        this.confirmPanel.add((Component)this.bOK, null);
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.centerPanel.add((Component)this.metalColorPanel, "North");
        this.metalColorPanel.add((Component)this.primary1, null);
        this.metalColorPanel.add((Component)this.primary2, null);
        this.metalColorPanel.add((Component)this.primary3, null);
        this.metalColorPanel.add((Component)this.secondary1, null);
        this.metalColorPanel.add((Component)this.secondary2, null);
        this.metalColorPanel.add((Component)this.secondary3, null);
        this.metalColorPanel.add((Component)this.white, null);
        this.metalColorPanel.add((Component)this.black, null);
        this.centerPanel.add((Component)this.compiereColorPanel, "Center");
        this.compiereColorPanel.add((Component)this.txt_error, null);
        this.centerPanel.add((Component)this.fontPanel, "South");
        this.fontPanel.add((Component)this.controlFont, null);
        this.fontPanel.add((Component)this.systemFont, null);
        this.fontPanel.add((Component)this.menuFont, null);
        this.fontPanel.add((Component)this.userFont, null);
        this.fontPanel.add((Component)this.windowFont, null);
        this.fontPanel.add((Component)this.smallFont, null);
        this.compiereColorPanel.add((Component)this.error, null);
        this.compiereColorPanel.add((Component)this.inactive, null);
        this.compiereColorPanel.add((Component)this.txt_ok, null);
        this.compiereColorPanel.add((Component)this.mandatory, null);
        this.compiereColorPanel.add((Component)this.info, null);
        this.bCancel.addActionListener(this);
        this.bOK.addActionListener(this);
    }

    private void loadTheme() {
        if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
            CompiereTheme.setTheme();
        } else {
            this.primary1.setEnabled(false);
            this.primary2.setEnabled(false);
            this.primary3.setEnabled(false);
            this.secondary1.setEnabled(false);
            this.secondary2.setEnabled(false);
            this.secondary3.setEnabled(false);
        }
    }

    private void dynInit() {
        CompiereTheme ct = CompiereLookAndFeel.getCompiereTheme();
        this.primary1.setBackground(ct.getPrimary1());
        this.primary2.setBackground(ct.getPrimary2());
        this.primary3.setBackground(ct.getPrimary3());
        this.secondary1.setBackground(ct.getSecondary1());
        this.secondary2.setBackground(ct.getSecondary2());
        this.secondary3.setBackground(ct.getSecondary3());
        this.white.setBackground(ct.getWhite());
        this.black.setBackground(ct.getSecondary3());
        this.black.setForeground(ct.getBlack());
        this.error.setBackground(CompierePLAF.getFieldBackground_Error());
        this.mandatory.setBackground(CompierePLAF.getFieldBackground_Mandatory());
        this.inactive.setBackground(CompierePLAF.getFieldBackground_Inactive());
        this.info.setBackground(CompierePLAF.getInfoBackground());
        this.txt_ok.setBackground(CompierePLAF.getFieldBackground_Normal());
        this.txt_ok.setForeground(CompierePLAF.getTextColor_OK());
        this.txt_error.setBackground(CompierePLAF.getFieldBackground_Normal());
        this.txt_error.setForeground(CompierePLAF.getTextColor_Issue());
        this.controlFont.setFont(ct.getControlTextFont());
        this.systemFont.setFont(ct.getSystemTextFont());
        this.userFont.setFont(ct.getUserTextFont());
        this.smallFont.setFont(ct.getSubTextFont());
        this.menuFont.setFont(ct.getMenuTextFont());
        this.windowFont.setFont(ct.getWindowTitleFont());
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bOK) {
            CompiereTheme.save(Ini.getProperties());
            this.dispose();
            return;
        }
        if (e.getSource() == this.bCancel) {
            this.dispose();
            return;
        }
        CompiereTheme vt = new CompiereTheme();
        try {
            if (e.getSource() == this.primary1) {
                CompiereTheme.primary1 = new ColorUIResource(JColorChooser.showDialog(this, s_res.getString("Primary1"), CompiereTheme.primary1));
            } else if (e.getSource() == this.primary2) {
                CompiereTheme.primary2 = new ColorUIResource(JColorChooser.showDialog(this, s_res.getString("Primary2"), CompiereTheme.primary2));
            } else if (e.getSource() == this.primary3) {
                CompiereTheme.primary3 = new ColorUIResource(JColorChooser.showDialog(this, s_res.getString("Primary3"), CompiereTheme.primary3));
            } else if (e.getSource() == this.secondary1) {
                CompiereTheme.secondary1 = new ColorUIResource(JColorChooser.showDialog(this, s_res.getString("Secondary1"), CompiereTheme.secondary1));
            } else if (e.getSource() == this.secondary2) {
                CompiereTheme.secondary2 = new ColorUIResource(JColorChooser.showDialog(this, s_res.getString("Secondary2"), CompiereTheme.secondary2));
            } else if (e.getSource() == this.secondary3) {
                CompiereTheme.secondary3 = new ColorUIResource(JColorChooser.showDialog(this, s_res.getString("Secondary3"), CompiereTheme.secondary3));
            } else if (e.getSource() == this.error) {
                CompiereTheme.error = new ColorUIResource(JColorChooser.showDialog(this, s_res.getString("Error"), CompiereTheme.error));
            } else if (e.getSource() == this.mandatory) {
                CompiereTheme.mandatory = new ColorUIResource(JColorChooser.showDialog(this, s_res.getString("Mandatory"), CompiereTheme.mandatory));
            } else if (e.getSource() == this.inactive) {
                CompiereTheme.inactive = new ColorUIResource(JColorChooser.showDialog(this, s_res.getString("Inactive"), CompiereTheme.inactive));
            } else if (e.getSource() == this.info) {
                CompiereTheme.info = new ColorUIResource(JColorChooser.showDialog(this, s_res.getString("Info"), CompiereTheme.info));
            } else if (e.getSource() == this.black) {
                CompiereTheme.black = new ColorUIResource(JColorChooser.showDialog(this, s_res.getString("Black"), CompiereTheme.black));
            } else if (e.getSource() == this.white) {
                CompiereTheme.white = new ColorUIResource(JColorChooser.showDialog(this, s_res.getString("White"), CompiereTheme.white));
            } else if (e.getSource() == this.txt_ok) {
                CompiereTheme.txt_ok = new ColorUIResource(JColorChooser.showDialog(this, s_res.getString("TextOK"), CompiereTheme.txt_ok));
            } else if (e.getSource() == this.txt_error) {
                CompiereTheme.txt_error = new ColorUIResource(JColorChooser.showDialog(this, s_res.getString("TextIssue"), CompiereTheme.txt_error));
            } else if (e.getSource() == this.controlFont) {
                CompiereTheme.controlFont = new FontUIResource(FontChooser.showDialog(this, s_res.getString("ControlFont"), vt.getControlTextFont()));
            } else if (e.getSource() == this.systemFont) {
                CompiereTheme.systemFont = new FontUIResource(FontChooser.showDialog(this, s_res.getString("SystemFont"), vt.getSystemTextFont()));
            } else if (e.getSource() == this.userFont) {
                CompiereTheme.userFont = new FontUIResource(FontChooser.showDialog(this, s_res.getString("UserFont"), vt.getUserTextFont()));
            } else if (e.getSource() == this.smallFont) {
                CompiereTheme.smallFont = new FontUIResource(FontChooser.showDialog(this, s_res.getString("SmallFont"), vt.getSubTextFont()));
            } else if (e.getSource() == this.menuFont) {
                CompiereTheme.menuFont = new FontUIResource(FontChooser.showDialog(this, s_res.getString("MenuFont"), vt.getMenuTextFont()));
            } else if (e.getSource() == this.windowFont) {
                CompiereTheme.windowFont = new FontUIResource(FontChooser.showDialog(this, s_res.getString("WindowTiteFont"), vt.getWindowTitleFont()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dynInit();
    }
}

